/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SeekAWord3ech
extends Applet {
    AudioClip found_sound;
    AppletUtil3 aut;
    boolean[] word_found;
    Button rescramble = new Button("Rescramble");
    Button find = new Button("Find Words");
    char[][] letters;
    Font f;
    int width;
    int height;
    int rows = 15;
    int columns = 15;
    int cell_size;
    int placed_words;
    List wordlist = new List();
    SeekCanvas3 canvas;
    String[] candidates;
    String[] words;
    Vector found_coords = new Vector(17);
    Vector word_coords = new Vector(17);

    public void init() {
        this.aut = new AppletUtil3(this);
        this.width = this.size().width;
        this.height = this.size().height;
        if (this.getParameter("ROWS") != null) {
            this.rows = this.aut.getRandom(this.getParameter("ROWS"));
        }
        if (this.getParameter("COLUMNS") != null) {
            this.columns = this.aut.getRandom(this.getParameter("COLUMNS"));
        }
        if (this.getParameter("FOUND.SOUND") != null) {
            try {
                this.found_sound = this.getAudioClip(this.getDocumentBase(), this.getParameter("FOUND.SOUND").trim());
            }
            catch (Exception exception) {}
        }
        this.cell_size = Math.min(this.width / this.columns, this.height / this.rows);
        this.letters = new char[this.rows][this.columns];
        String string = this.getParameter("WORDLIST") != null ? this.getParameter("WORDLIST") : "Bridget Chloe Claire Gwyneth Judith Jennifer Kate Kirsten Lacey Larisa Mischa Natalie Neve Parker Winona";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        this.candidates = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.candidates[n2] = stringTokenizer.nextToken().toUpperCase();
            ++n2;
        }
        this.constructBoard();
        this.wordlist.setMultipleSelections(true);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        panel.setBackground(this.aut.makeColor(this.getParameter("BGCOLOR"), Color.lightGray));
        panel.setForeground(this.aut.makeColor(this.getParameter("FGCOLOR"), Color.black));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1, 0, 0));
        panel2.add(this.find);
        panel2.add(this.rescramble);
        panel.add("Center", this.wordlist);
        panel.add("South", panel2);
        this.canvas = new SeekCanvas3(this, this.cell_size * this.columns, this.cell_size * this.rows);
        this.canvas.repaint();
        this.canvas.setBackground(this.aut.makeColor(this.getParameter("CANVAS.BGCOLOR"), Color.lightGray));
        this.canvas.setForeground(this.aut.makeColor(this.getParameter("CANVAS.FGCOLOR"), Color.black));
        this.canvas.setFont(this.aut.makeFont(this.getParameter("CANVAS.FONTNAME"), this.getParameter("CANVAS.FONTSTYLE"), this.getParameter("CANVAS.FONTSIZE")));
        this.setLayout(new BorderLayout(0, 0));
        this.add("West", this.canvas);
        this.add("Center", panel);
    }

    public void constructBoard() {
        if (this.getParameter("AUTHOR").equals("Eric Harshbarger, http://www.ericharshbarger.org") && this.getParameter("COPYRIGHT").equals("SeekAWord applet, Copyright 1998, Eric Harshbarger")) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            while (n5 < this.rows) {
                n4 = 0;
                while (n4 < this.columns) {
                    this.letters[n5][n4] = '\u0000';
                    ++n4;
                }
                ++n5;
            }
            this.found_coords.removeAllElements();
            this.word_coords.removeAllElements();
            n4 = 0;
            double d = 1.0;
            int n6 = 0;
            int[] nArray = new int[9];
            int n7 = 0;
            while (n7 < 9) {
                nArray[n7] = 0;
                ++n7;
            }
            while (n6 < this.candidates.length && n4 < 5000) {
                int n8;
                n3 = (int)(Math.random() * 9.0);
                if (n3 == 4 || !((double)nArray[n3] < d / 6.0)) continue;
                n2 = n3 % 3 - 1;
                n = n3 / 3 - 1;
                int n9 = (int)(Math.random() * (double)(this.columns - Math.abs(n2) * this.candidates[n6].length()) + (double)(Math.max(0, -n2) * this.candidates[n6].length()));
                if (this.putWord(n6, n2, n, n9, n8 = (int)(Math.random() * (double)(this.rows - Math.abs(n) * this.candidates[n6].length()) + (double)(Math.max(0, -n) * this.candidates[n6].length())))) {
                    int n10 = n3;
                    nArray[n10] = nArray[n10] + 1;
                    d += 1.0;
                    ++n6;
                }
                ++n4;
            }
            this.placed_words = n6;
            n3 = 0;
            while (n3 < this.rows) {
                n2 = 0;
                while (n2 < this.columns) {
                    if (this.letters[n3][n2] == '\u0000') {
                        n = (int)(Math.random() * 26.0 + 65.0);
                        this.letters[n3][n2] = (char)n;
                    }
                    ++n2;
                }
                ++n3;
            }
            this.word_found = new boolean[this.placed_words];
            n2 = 0;
            while (n2 < this.word_found.length) {
                this.word_found[n2] = false;
                ++n2;
            }
            this.makeList();
            return;
        }
        System.out.println("AUTHOR & COPYRIGHT parameters are incorrect.");
    }

    public boolean putWord(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.candidates[n].length();
        char[] cArray = new char[n6];
        int n7 = 0;
        while (n7 < n6) {
            char c = this.candidates[n].charAt(n7);
            if (this.letters[n5 + n7 * n3][n4 + n7 * n2] == '\u0000' || this.letters[n5 + n7 * n3][n4 + n7 * n2] == c) {
                cArray[n7] = c;
                if (n7 == n6 - 1) {
                    int n8 = 0;
                    while (n8 < n6) {
                        this.letters[n5 + n8 * n3][n4 + n8 * n2] = cArray[n8];
                        ++n8;
                    }
                    int[] nArray = new int[]{n4, n5, n4 + n7 * n2, n5 + n7 * n3};
                    this.word_coords.addElement(nArray);
                    return true;
                }
            } else {
                return false;
            }
            ++n7;
        }
        return false;
    }

    public void destroy() {
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            if (event.target == this.rescramble) {
                this.constructBoard();
            } else if (event.target == this.find) {
                String[] stringArray = this.wordlist.getSelectedItems();
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = 0;
                    while (n2 < this.placed_words) {
                        if (stringArray[n].equals(this.candidates[n2])) {
                            this.word_found[n2] = true;
                            int[] nArray = (int[])this.word_coords.elementAt(n2);
                            this.found_coords.addElement(nArray);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
                this.makeList();
            }
            this.canvas.drawFoundWords();
        }
        return super.handleEvent(event);
    }

    public void makeList() {
        this.wordlist.clear();
        int n = 0;
        while (n < this.placed_words) {
            if (!this.word_found[n]) {
                this.wordlist.addItem(this.candidates[n]);
            }
            ++n;
        }
    }

    public void playFoundSound() {
        if (this.found_sound != null) {
            this.found_sound.play();
        }
    }

    public int getPlacedWordCount() {
        return this.placed_words;
    }

    public Vector getFoundCoords() {
        return this.found_coords;
    }

    public void addFoundCoords(int[] nArray) {
        this.found_coords.addElement(nArray);
    }

    public String getWord(int n) {
        return this.candidates[n];
    }

    public boolean getWordFound(int n) {
        return this.word_found[n];
    }

    public void setWordFound(int n, boolean bl) {
        this.word_found[n] = bl;
    }

    public char[][] getLetters() {
        return this.letters;
    }
}

