package control;

import java.awt.*;
import control.*;
import java.math.*;
public class Turret implements Hurtable, LevelObject
{
    boolean stopped = false;
    double dangle;
    double angle;
    Car car;
    Screen screen;
    double x;
    double y;
    Sprite sprite;
    BlockSystem control;
    
    LinePaintable laser;
    TextPaintable healthText;
    double tox;
    double toy;
    
    double hp = 500;
    int count = 0;
    boolean gold = false;
    int coins = 1000;
    public Turret( Car n, Screen window, double dx, double dy, BlockSystem blocksys, boolean go )
    {
        gold = true;
        car = n;
        screen = window;
        x = dx;
        y = dy;
        angle = 0;
        control = blocksys;
        hp = 1500;
        sprite = screen.newSprite( "/images/turret_gold.png" );
        sprite.setPosition( dx, dy );
        sprite.setObj( this );
        sprite.setComment( "hittable" );
        sprite.setAnchorPosition( 18, 16 );
        
        laser = new LinePaintable( screen, Color.GREEN, 0, 0, 0, 0 );
        healthText = new TextPaintable( screen );
        Font font;
        font = Font.decode( "sans-10" );
        healthText.setFont( font );
        healthText.setX( dx - 10 );
        healthText.setY( dy - 40 );
        healthText.setColor( Color.YELLOW );
        healthText.setText( "18" );
        control.addBlocker( sprite );
        
        Runnable run = new Runnable()
        {
            public void run()
            {
                while ( ! Turret.this.stopped )
                {
                    try
                    {
                        Thread.sleep( 10 );
                    }
                    catch ( InterruptedException ex )
                    {
                        
                    }
                    shootTurret();
                    checkMouseOver();
                }
            }
        };
        
        new Thread( run ).start();
    }
    public Turret( Car n, Screen window, double dx, double dy, BlockSystem blocksys )
    {
        car = n;
        screen = window;
        x = dx;
        y = dy;
        angle = 0;
        control = blocksys;
        sprite = screen.newSprite( "/images/turret.png" );
        sprite.setPosition( dx, dy );
        sprite.setObj( this );
        sprite.setComment( "hittable" );
        sprite.setAnchorPosition( 18, 16 );
        
        laser = new LinePaintable( screen, Color.RED, 0, 0, 0, 0 );
        healthText = new TextPaintable( screen );
        Font font;
        font = Font.decode( "sans-10" );
        healthText.setFont( font );
        healthText.setX( dx - 10 );
        healthText.setY( dy - 40 );
        healthText.setColor( Color.LIGHT_GRAY );
        healthText.setText( "18" );
        control.addBlocker( sprite );
        
        Runnable run = new Runnable()
        {
            public void run()
            {
                while ( ! Turret.this.stopped )
                {
                    try
                    {
                        Thread.sleep( 50 );
                    }
                    catch ( InterruptedException ex )
                    {
                        
                    }
                    shootTurret();
                    checkMouseOver();
                }
            }
        };
        
        new Thread( run ).start();
    }
    public boolean shootTurret()
    {
        if ( screen.isGameOver() )
        {
            this.stopped = true;
            screen.clear();
            return false;
        }
        angle = Math.atan2( x - car.getX(), car.getY() - y );
        sprite.setRadians( angle );
        boolean move = false;
        double dx = x - Math.sin( angle ) * 20;
        double dy = y + Math.cos( angle ) * 20;
        double tempx = dx;
        double tempy = dy;
        
        boolean temp = false;
        
        tempx = tempx - Math.sin( angle ) * 20;
        tempy = tempy + Math.cos( angle ) * 20;
        
        while ( ! move )
        {
            tempx = tempx - Math.sin( angle ) * 1;
            tempy = tempy + Math.cos( angle ) * 1;
            
            if ( control.isBlocked( tempx, tempy, "car" ) )
            {
                temp = true;
                move = true;
                tox = tempx;
                toy = tempy;
            }
            else if ( control.isBlocked( tempx, tempy, "" ) )
            {
                temp = false;
                move = true;
                tox = tempx;
                toy = tempy;
            }
            
            if ( tempx < 0 || tempx > screen.getWidth() || tempy < 0 || tempy > screen.getHeight() )
            {
                temp = false;
                move = true;
                tox = tempx;
                toy = tempy;
            }
        }
        
        laser.repositionLine( dx, dy, tox, toy );
        
        count ++;
        if ( count == 5 )
        {
            count = 0;
        }
        else
        {
            temp = true;
        }
        angle = angle + Chess.getRan( - .1, .1 );
        if ( ! temp )
        {
            if ( ! screen.isPaused() )
            {
                new Bullet( angle, dx, dy, screen, control, "hittable", "car" );
            }
            else
            {
                // laser.repositionLine( 0, 0, 0, 0 );
            }
        }
        return false;
    }
    public boolean canDie()
    {
        return true;
    }
    public boolean isDead()
    {
        return hp == 0;
    }
    public void killSelf()
    {
        // Not needed.
    }
    public void hitByBullet( double damage )
    {
        hp -= damage;
        if  ( hp < 0 )
        {
            hp = 0;
        }
        if ( hp == 0 && ! stopped )
        {
            stopped = true;
            sprite.setImage( "/images/explosion.gif" );
            Chess.sleep( 200 );
            control.removeBlocker( sprite );
            screen.destroySprite( sprite );
            laser.repositionLine( -1, -1, -1, -1 );
            healthText.hide();
            screen.setCoins( screen.getCoins() + coins );
            // sprite = null;
        }
    }
    public void checkMouseOver()
    {
        double dx = screen.getRTMouseX();
        double dy = screen.getRTMouseY();
        
        if ( sprite.overlaps( (int) dx, (int) dy ) )
        {
            healthText.reveal();
            healthText.setText( "" + (int) hp );
        }
        else
        {
            healthText.hide();
        }
    }
}
