/*
 * TextPaintable.java
 *
 * Created on June 14, 2007, 2:31 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package control;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

/**
 *
 * @author Home
 */
public class TextPaintable implements  Paintable
{

    String comment = "";
    Screen screen;
    /** Creates a new instance of TextPaintable */
    public TextPaintable( Screen win )
    {
        screen = win;
        screen.addPaintable( this );
    }
    public TextPaintable( Screen win, String com )
    {
        screen = win;
        comment = com;
        screen.addPaintable( this );
    }
    public void paint( Graphics2D g )
    {
        if ( ! comment.equals( "end" ) && screen.isGameOver() )
        {
            setText( "" );
        }
        if ( hidden == true )
        {
            setText( "" );
        }
        g.setColor( color );
        g.setFont( font );
        g.drawString( text, (int)x, (int)y );
    }
    boolean hidden = false;
    public void hide()
    {
        hidden = true;
    }
    public void reveal()
    {
        hidden = false;
    }
    /**
     * Holds value of property text.
     */
    private String text="text";

    /**
     * Getter for property text.
     * @return Value of property text.
     */
    public String getText()
    {
        return this.text;
    }

    /**
     * Setter for property text.
     * @param text New value of property text.
     */
    public void setText(String text)
    {
        this.text = text;
    }

    /**
     * Holds value of property x.
     */
    private double x;

    /**
     * Getter for property x.
     * @return Value of property x.
     */
    public double getX()
    {
        return this.x;
    }

    /**
     * Setter for property x.
     * @param x New value of property x.
     */
    public void setX(double x)
    {
        this.x = x;
    }

    /**
     * Holds value of property y.
     */
    private double y;

    /**
     * Getter for property y.
     * @return Value of property y.
     */
    public double getY()
    {
        return this.y;
    }

    /**
     * Setter for property y.
     * @param y New value of property y.
     */
    public void setY(double y)
    {
        this.y = y;
    }

    /**
     * Holds value of property color.
     */
    private Color color = Color.BLACK;

    /**
     * Getter for property color.
     * @return Value of property color.
     */
    public Color getColor()
    {
        return this.color;
    }

    /**
     * Setter for property color.
     * @param color New value of property color.
     */
    public void setColor(Color color)
    {
        this.color = color;
    }

    /**
     * Holds value of property size.
     */
    private int size = 12;

    /**
     * Getter for property size.
     * @return Value of property size.
     */
    public int getSize()
    {
        return this.size;
    }

    /**
     * Setter for property size.
     * @param size New value of property size.
     */
    public void setSize(int size)
    {
        this.size = size;
    }

    /**
     * Holds value of property font.
     */
    private Font font;

    /**
     * Getter for property font.
     * @return Value of property font.
     */
    public Font getFont()
    {
        return this.font;
    }

    /**
     * Setter for property font.
     * @param font New value of property font.
     */
    public void setFont(Font font)
    {
        this.font = font;
    }
    

    
}
