package control;
import control.*;
import javax.swing.JApplet;

/**
 * A RunnableApplet is an applet that implements the Runnable interface to 
 * simplify applet construction. This
 * is used so that newbies can implement the class (by writing the run method)
 * and not have to worry about the mechanics of creating a Thread.  If start() 
 * is overriden, then super.start() must be called for the thread to start!
 * The applet is passed into Chess.newScreen( JApplet ) so that a Screen is 
 * added properly to appear within the Applet's content pane.  It is important
 * that the init method return without doing anything other than initializing
 * variables, if the game loop is in the init method, then the applet will 
 * not work!  Drawing and Game interactivity should be the run method.
 * Also, the user needs to click on the applet to give keyboard focus, and the 
 * Screen displays messages to encourage that.
 */
public abstract class RunnableApplet extends JApplet implements Runnable {
        
    /**
     * Creates an instance of the applet.
     */
    public RunnableApplet() {
    }
    
    /**
     * be sure to call super.start() if you override this method.
     */
    public void start() {        
        new Thread( this ).start();        
    }
    
    /**
     * Implement this in your instance.  This is where the game loop should be.
     */
    public abstract void run();
}
