package control;

import java.util.LinkedList;

public class LevelManager implements ButtonBuilder
{
    LinkedList levelOne;
    LinkedList levelTwo;
    
    LinkedList levelThree;
    
    BlockSystem control;
    Screen screen;
    Car car;
    
    GarageButton nextL;
    
    int currentLevel;
    
    public LevelManager( Screen s, BlockSystem b, Car c )
    {
        
        screen = s;
        control = b;
        car = c;
        
        levelOne = new LinkedList();
        levelTwo = new LinkedList();
        levelThree = new LinkedList();
        
        setLevel( 1 );
        drawLevel( getCurrentLevel() );
        
        Runnable run = new Runnable()
        {
            public void run()
            {
                while ( true )
                {
                    try
                    {
                        Thread.sleep( 20 );
                    }
                    catch ( InterruptedException e )
                    {
                        
                    }
                    
                    callLoop();
                }
            }
        };
        
        new Thread( run ).start();
        
    }
    public int getCurrentLevel()
    {
        return currentLevel;
    }
    public void callLoop()
    {
        checkLevel( getCurrentLevel() );
    }
    public boolean checkLevel( int level )
    {
        LinkedList list = getList( level );
        
        for ( Object a : list )
        {
            LevelObject obj = (LevelObject) a;
            if ( ! obj.isDead() )
            {
                if ( obj.canDie() )
                {
                    return false;
                }
            }
        }
        
        if ( nextL == null )
        {
            showLevelButton();
        }
        return true;
    }
    public void showLevelButton()
    {
        nextL = new GarageButton( screen, 375, 570, "/images/buttons/button_nextlevel.png", "/images/buttons/button_nextlevel_selected.png", this, "nextlevel" );
    }
    public void buttonDown( String c )
    {
        if ( c == "nextlevel" )
        {
            nextLevel();
            nextL = null;
            nextL.destroyButton();
        }
    }
    public void nextLevel()
    {
        if ( getCurrentLevel() < 3 )
        {
            LinkedList list = getList( getCurrentLevel() );
            
            for ( Object a : list )
            {
                LevelObject obj = (LevelObject) a;
                obj.killSelf();
            }
            
            car.setAmmo( car.getMaxAmmo() );
            car.setHP( car.getMaxHP() );
            setLevel( getCurrentLevel() + 1 );
            drawLevel( getCurrentLevel() );
        }
    }
    public void drawLevelOne()
    {
        addObject( new DefaultBuilding( screen, control, "/images/building.png", 650, 0 ), getCurrentLevel() );
        
        addObject( new Barrel( screen, control, 590, 280 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 570, 315 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 580, 340 ), getCurrentLevel() );
        
        addObject( new Barrel( screen, control, 320, 400 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 348, 390 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 376, 380 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 404, 390 ), getCurrentLevel() );
        
        addObject( new DefaultBuilding( screen, control, "/images/garage.png", 100, 100, "garage" ), getCurrentLevel() );
        addObject( new Turret( car, screen, 430, 150, control ), getCurrentLevel() );
    }
    public void drawLevelTwo()
    {
        addObject( new DefaultBuilding( screen, control, "/images/garage.png", 750, 100, "garage" ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 620, 200 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 640, 230 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 630, 260 ), getCurrentLevel() );
        addObject( new Turret( car, screen, 230, 150, control ), getCurrentLevel() );
        addObject( new Turret( car, screen, 330, 170, control ), getCurrentLevel() );
        addObject( new Turret( car, screen, 430, 150, control ), getCurrentLevel() );
    }
    public void drawLevelThree()
    {
        addObject( new Turret( car, screen, 440, 440, control, true ), getCurrentLevel() );
        addObject( new Turret( car, screen, 390, 150, control ), getCurrentLevel() );
        addObject( new Turret( car, screen, 210, 120, control ), getCurrentLevel() );
        addObject( new Turret( car, screen, 170, 320, control ), getCurrentLevel() );
        addObject( new Turret( car, screen, 220, 70, control, true ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 635, 230 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 620, 260 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 630, 290 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 620, 320 ), getCurrentLevel() );
        addObject( new Barrel( screen, control, 640, 350 ), getCurrentLevel() );
        addObject( new DefaultBuilding( screen, control, "/images/garage.png", 80, 100, "garage" ), getCurrentLevel() );
    }
    public void drawLevel( int level )
    {
        if ( level == 1 )
        {
            drawLevelOne();
        }
        else if ( level == 2 )
        {
            drawLevelTwo();
        }
        else if ( level == 3 )
        {
            drawLevelThree();
        }
    }
    public void setLevel( int level )
    {
        currentLevel = level;
    }
    public void addObject( LevelObject obj, int level )
    {
        LinkedList list = getList( getCurrentLevel() );
        
        list.add( obj );
    }
    public LinkedList getList( int level )
    {
        LinkedList list = new LinkedList();
        if ( level == 1 )
        {
            list = levelOne;
        }
        else if ( level == 2 )
        {
            list = levelTwo;
        }
        else if ( level == 3 )
        {
            list = levelThree;
        }
        else
        {
            return null;
        }
        return list;
    }
}
