package control;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;

public class GarageUpgrade implements ButtonBuilder
{
    Screen screen;
    Sprite sprite;
    
    GarageButton healthButton;
    GarageButton ammoButton;
    GarageButton speedButton;
    GarageButton livesButton;
    GarageButton buyButton;
    GarageButton exitButton;
    
    Point point;
    
    TextPaintable coinsText;
    TextPaintable descriptionText;
    TextPaintable priceText;
    TextPaintable descriptionText2;
    
    String selected = "health";
    int selectedPrice;
    
    int cPrice = 0;
    int cCoins = 0;
    String cDescription = "";
    String cDescription2 = "";
    Car car;
    
    public GarageUpgrade( Screen window, BlockSystem blocksys, Car c )
    {
        screen = window;
        
        car = c;
        
        screen.setPaused( true );
        
        sprite = screen.newSprite( "/images/gui_upgrades.png" );
        sprite.setPosition( screen.getWidth() / 2, screen.getHeight() / 2 );
        
        point = getMenuPosition();
        
        
        healthButton = new GarageButton( screen, point.getX() + 57, point.getY() + 74, "/images/buttons/button_1.png", "/images/buttons/button_1_selected.png", this, "health" );
        ammoButton = new GarageButton( screen, point.getX() + 105, point.getY() + 74, "/images/buttons/button_2.png", "/images/buttons/button_2_selected.png", this, "ammo" );
        speedButton = new GarageButton( screen, point.getX() + 155, point.getY() + 74, "/images/buttons/button_3.png", "/images/buttons/button_3_selected.png", this, "speed" );
        livesButton = new GarageButton( screen, point.getX() + 204, point.getY() + 74, "/images/buttons/button_4.png", "/images/buttons/button_4_selected.png", this, "lives" );
        buyButton = new GarageButton( screen, point.getX() + 80, point.getY() + 200, "/images/buttons/button_buy.png", "/images/buttons/button_buy_selected.png", this, "buy" );
        exitButton = new GarageButton( screen, point.getX() + 273, point.getY() + 4, "/images/buttons/button_exit.png", "/images/buttons/button_exit_selected.png", this, "exit");
        
        coinsText = new TextPaintable( screen );
        descriptionText = new TextPaintable( screen );
        priceText = new TextPaintable( screen );
        descriptionText2 = new TextPaintable( screen );
        
        Font font = null;
        font = Font.decode( "sans-14" );
        
        coinsText.setFont( font );
        descriptionText.setFont( font );
        priceText.setFont( font );
        descriptionText2.setFont( font );
        
        coinsText.setX( point.getX() + 40 );
        coinsText.setY( point.getY() + 270 );
        
        descriptionText.setX( point.getX() + 40 );
        descriptionText.setY( point.getY() + 160 );
        
        priceText.setX( point.getX() + 40 );
        priceText.setY( point.getY() + 140 );
        
        descriptionText2.setX( point.getX() + 40 );
        descriptionText2.setY( point.getY() + 180 );
        
        buttonDown( "health" );
        
        cPrice = 200;
        
        Runnable run = new Runnable()
        {
            public void run()
            {
                while ( true )
                {
                    try
                    {
                        Thread.sleep( 20 );
                    }
                    catch ( InterruptedException e )
                    {
                        
                    }
                    callFunctions();
                }
            }
        };
        
        new Thread( run ).start();
    }
    public void callFunctions()
    {
        updateText();
    }
    public void updateText()
    {
        cCoins = screen.getCoins();
        
        coinsText.setText( "You have " + cCoins + " coins." );
        priceText.setText( "Price: " + cPrice + " coins" );
        descriptionText.setText( cDescription );
        descriptionText2.setText( cDescription2 );
    }
    public Point getMenuPosition()
    {
        Point p = new Point();
        p.setLocation( screen.getWidth() / 2 - 150, screen.getHeight() / 2 - 150 );
        return p;
    }
    public void buttonDown( String c )
    {
        if ( c.equals( "health" ) )
        {
            cDescription = "You can upgrade your health by";
            cDescription2 = "buying this health upgrade.";
            
            cPrice = 200;
            
            selected = "health";
            selectedPrice = 200;
        }
        if ( c.equals( "ammo" ) )
        {
            cDescription = "You can upgrade your ammo by";
            cDescription2 = "buying this ammo upgrade.";
            
            cPrice = 200;
            
            selected = "ammo";
            selectedPrice = 200;
        }
        if ( c.equals( "lives" ) )
        {
            cDescription = "You can add one life by buying";
            cDescription2 = "this extra life.";
            
            cPrice = 100;
            
            selected = "lives";
            selectedPrice = 100;
        }
        if ( c.equals( "speed" ) )
        {
            cDescription = "You can upgrade your speed by";
            cDescription2 = "buying this speed upgrade.";
            
            cPrice = 300;
            
            selected = "speed";
            selectedPrice = 300;
        }
        if ( c.equals( "exit" ) )
        {
            Runnable run = new Runnable()
            {
                public void run()
                {
                    screen.destroySprite( healthButton.getSprite() );
                    screen.destroySprite( ammoButton.getSprite() );
                    screen.destroySprite( speedButton.getSprite() );
                    screen.destroySprite( livesButton.getSprite() );
                    screen.destroySprite( exitButton.getSprite() );
                    screen.destroySprite( buyButton.getSprite() );
                    screen.destroySprite( sprite );
                    coinsText.hide();
                    priceText.hide();
                    descriptionText.hide();
                    descriptionText2.hide();
                    priceText.hide();
                    car.exitGarage();
                }
            };
            new Thread( run ).start();
        }
        if ( c.equals( "buy" ) )
        {
            if ( screen.getCoins() >= selectedPrice )
            {
                screen.setCoins( screen.getCoins() - selectedPrice );
                Car car = screen.getCar();
                
                if ( selected.equals( "health" ) )
                {
                    car.setMaxHP( car.getMaxHP() + 100 );
                }
                else if ( selected.equals( "ammo" ) )
                {
                    car.setMaxAmmo( car.getMaxAmmo() + 100 );
                }
                else if ( selected.equals( "lives" ) )
                {
                    car.setLives( car.getLives() + 1 );
                }
                else if ( selected.equals( "speed" ) )
                {
                    car.setSpeed( car.getSpeed() + 5 );
                }
            }
        }
    }
    
}
