package control;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class GarageButton
{
    
    /** Creates a new instance of GarageButton */
    
    double x;
    double y;
    
    Screen screen;
    Sprite sprite;
    String image;
    String dragimage;
    String comment;
    ButtonBuilder g;
    
    boolean stopped = false;
    
    public GarageButton( Screen window, double dx, double dy, String img, String dragimg, ButtonBuilder n, String com )
    {
        x = dx;
        y = dy;
        
        g = n;
        
        comment = com;
        
        image = img;
        dragimage = dragimg;
        
        screen = window;
        
        sprite = screen.newSprite( img );
        
        sprite.setAnchorPosition( 0, 0 );
        
        sprite.setPosition( x, y );
        
        screen.addMouseInputAdapter( new MouseInputAdapter()
        {
            public void mouseClicked( MouseEvent e )
            {
                if ( sprite.overlaps( (int) e.getPoint().getX(), (int) e.getPoint().getY() ) )
                {
                    g.buttonDown( comment );
                }
            }
            
            
        } );
        
        Runnable run = new Runnable()
        {
            public void run()
            {
                while ( ! stopped )
                {
                    try
                    {
                        Thread.sleep( 20 );
                    }
                    catch ( InterruptedException ex )
                    {
                        
                    }
                    checkOver();
                }
            }
        };
        new Thread( run ).start();
    }
    
    public void checkOver()
    {
        if ( sprite.overlaps( (int) screen.getRTMouseX(), (int) screen.getRTMouseY() ) )
        {
            sprite.setImage( dragimage );
        }
        else
        {
            sprite.setImage( image );
        }
    }
    public void destroyButton()
    {
        stopped = true;
        screen.destroySprite( sprite );
    }
    public Sprite getSprite()
    {
        return sprite;
    }
}
