package control;

public class DefaultBuilding implements LevelObject
{
    Screen screen;
    BlockSystem control;
    Sprite sprite;
    public DefaultBuilding( Screen s, BlockSystem b, String image, double dx, double dy )
    {
        control = b;
        screen = s;
        sprite = screen.newSprite( image, (int) dx, (int) dy );
        sprite.setAnchorPosition( 0, 0 );
        control.addBlocker( sprite );
    }
    public DefaultBuilding( Screen s, BlockSystem b, String image, double dx, double dy, String comment )
    {
        control = b;
        screen = s;
        sprite = screen.newSprite( image, (int) dx, (int) dy );
        sprite.setComment( comment );
        control.addBlocker( sprite );
    }
    public void killSelf()
    {
        control.removeBlocker( sprite );
        screen.destroySprite( sprite );
    }
    public boolean canDie()
    {
        return false;
    }
    public boolean isDead()
    {
        return false;
    }
}
