package control;
import control.*;
import java.awt.*;
import java.awt.Shape.*;

public class Car implements Hurtable
{
    
    Sprite sprite;
    Sprite gSprite;
    Screen screen;
    double angle = 0;
    BlockSystem control;
    /** Creates a new instance of Car */
    public Car( Screen window, BlockSystem blocksys )
    {
        control = blocksys;
        hp = 100;
        screen = window;
        screen.setCar( this );
        sprite = screen.newSprite( "/images/car_1.png" );
        returnHome();
        sprite.setComment( "car" );
        sprite.setObj( this );
        control.addBlocker( sprite );
        // sprite.setAnchorPosition( 35, 2 ); // Doesnt really work
    }
    public int getX()
    {
        return sprite.getPositionX();
    }
    public int getY()
    {
        return sprite.getPositionY();
    }
    public void hitByBullet( double damage )
    {
        hp -= damage;
        if ( hp < 0 )
        {
            hp = 0;
            killCar();
        }
    }
    public void youLose()
    {
        for ( Object a: screen.getAllSprites() )
        {
            screen.removeSprite( (Sprite) a );
        }
        for ( Object i: screen.getAllPaintables() )
        {
            TextPaintable n = (TextPaintable) i;
        }
        screen.clear();
        screen.setGameOver( true );
    }
    public void killCar()
    {
        setLives( getLives() - 1 );
        sprite.setImage( "images/explosion.gif" );
        Chess.sleep( 150 );
        sprite.hide();
        if ( getLives() > -1 )
        {
            returnHome();
            Chess.sleep( 2000 );
            sprite.reveal();
            sprite.setImage( "images/car_1.png" );
            setHP( getMaxHP() );
        }
        else
        {
            youLose();
        }
    }
    public double getRadians()
    {
        return sprite.getRadians();
    }
    public boolean turnObj( double turn )
    {
        if ( getHP() == 0 )
        {
            return false;
        }
        angle = angle + turn;
        sprite.setRadians( sprite.getRadians() + turn );
        return false;
    }
    public void returnHome()
    {
        sprite.setPosition( 730, 330 );
    }
    public double getDX( int forward )
    {
        return sprite.getPositionX() - ( Math.sin( angle ) * forward );
    }
    public double getDY( int forward )
    {
        return sprite.getPositionY() + ( Math.cos( angle ) * forward );
    }
    public double getPX( double pos, int forward )
    {
        return pos - ( Math.sin( angle ) * forward );
    }
    public double getPY( double pos, int forward )
    {
        return pos + ( Math.cos( angle ) * forward );
    }
    public void setPosition( double dx, double dy )
    {
        sprite.setPosition( dx, dy );
    }
    public void exitGarage()
    {
        gSprite.setImage( "/images/garage_carexit.gif" );
        Chess.sleep( 2860 );
        screen.setPaused( false );
        gSprite.setImage( "/images/garage.png" );
        sprite.reveal();
    }
    public boolean canMove( double dx, double dy )
    {
        if ( control.isBlocked( getPX( dx, 50 ), getPY( dy, 50 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 20 ), getPY( dy, 20 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 10 ), getPY( dy, 10 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, -50 ), getPY( dy, -50 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, -20 ), getPY( dy, -20 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, -10 ), getPY( dy, -10 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, -10 ), getPY( dy, -5 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, -5 ), getPY( dy, -10 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 10 ), getPY( dy, 5 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ), getPY( dy, 10 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ) - 30, getPY( dy, 10 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ) + 30, getPY( dy, 10 ), "car" ) )
        {
            return false;
        }
        
        if ( control.isBlocked( getPX( dx, 5 ) - 30, getPY( dy, 10 ), "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ) - 30, getPY( dy, 10 ) - 30, "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ) - 30, getPY( dy, 10 ) + 30, "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ) + 30, getPY( dy, 10 ) - 30, "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getPX( dx, 5 ) + 30, getPY( dy, 10 ) + 30, "car" ) )
        {
            return false;
        }
        if ( control.isBlocked( getX(), getY(), "car" ) )
        {
            return false;
        }
        return true;
    }
    public boolean moveObj( double forward )
    {
        // double dx = sprite.getPositionX() - ( Math.sin( angle ) * forward );
        // double dy = sprite.getPositionY() + ( Math.cos( angle ) * forward );
        double dx = getDX( (int) forward );
        double dy = getDY( (int) forward );
        if ( getHP() == 0 )
        {
            return false;
        }
        if ( ! canMove( sprite.getPositionX(), sprite.getPositionY() ) )
        {
            // return false;
        }
        if ( ! canMove( dx, dy ) )
        {
            // return false;
        }
        if ( canMove( dx, getY() ) )
        {
            if ( dx > 40 && dx < screen.getWidth() - 40 )
            {
                sprite.setPosition( dx, getY() );
            }
        }
        if ( canMove( getX(), dy ) )
        {
            if ( dy > 40 && dy < screen.getHeight() - 160 )
            {
                sprite.setPosition( getX(), dy );
            }
        }
        
        if ( control.getBlocker( getDX( 60 ), getDY( 60 ), "garage" ) != null )
        {
            screen.setPaused( true );
            Sprite sp = control.getBlocker( getDX( 60 ), getDY( 60 ), "garage" );
            sprite.hide();
            sp.setImage( "/images/garage_carenter.gif" );
            gSprite = sp;
            int frameCount = 0;
            Chess.sleep( 2860 );
            sp.setImage( "/images/garage.png" );
            new GarageUpgrade( screen, control, this );
        }
        
        
        if ( control.spriteBlocked( sprite ) )
        {
            //   return false;
        }
        if ( dx > 40 && dx < screen.getWidth() - 40 )
        {
            //sprite.setPosition( dx, getY() );
        }
        if ( dy > 40 && dy < screen.getHeight() - 190 )
        {
            //sprite.setPosition( getX(), dy );
        }
        return false;
    }
    
    /**
     * Holds value of property hp.
     */
    private double hp;
    
    /**
     * Getter for property hp.
     * @return Value of property hp.
     */
    public double getHP()
    {
        return this.hp;
    }
    
    /**
     * Setter for property hp.
     * @param hp New value of property hp.
     */
    public void setHP(double h)
    {
        this.hp = h;
    }
    
    /**
     * Holds value of property maxhp.
     */
    private double maxhp = 100;
    
    /**
     * Getter for property maxhp.
     * @return Value of property maxhp.
     */
    public double getMaxHP()
    {
        return this.maxhp;
    }
    
    /**
     * Setter for property maxhp.
     * @param maxhp New value of property maxhp.
     */
    public void setMaxHP(double maxh)
    {
        this.maxhp = maxh;
    }
    
    /**
     * Holds value of property speed.
     */
    private double speed = 20;
    
    /**
     * Getter for property speed.
     * @return Value of property speed.
     */
    public double getSpeed()
    {
        return this.speed;
    }
    
    /**
     * Setter for property speed.
     * @param speed New value of property speed.
     */
    public void setSpeed(double speed)
    {
        this.speed = speed;
    }
    
    /**
     * Holds value of property lives.
     */
    private int lives = 3; // Changed for debugging, was at 3
    
    /**
     * Getter for property lives.
     * @return Value of property lives.
     */
    public int getLives()
    {
        return this.lives;
    }
    
    /**
     * Setter for property lives.
     * @param lives New value of property lives.
     */
    public void setLives(int lives)
    {
        this.lives = lives;
    }
    
    /**
     * Holds value of property ammo.
     */
    private int ammo;
    
    /**
     * Getter for property ammo.
     * @return Value of property ammo.
     */
    public int getAmmo()
    {
        return this.ammo;
    }
    
    /**
     * Setter for property ammo.
     * @param ammo New value of property ammo.
     */
    public void setAmmo(int ammo)
    {
        this.ammo = ammo;
    }
    
    /**
     * Holds value of property maxAmmo.
     */
    private int maxAmmo;
    
    /**
     * Getter for property maxAmmo.
     * @return Value of property maxAmmo.
     */
    public int getMaxAmmo()
    {
        return this.maxAmmo;
    }
    
    /**
     * Setter for property maxAmmo.
     * @param maxAmmo New value of property maxAmmo.
     */
    public void setMaxAmmo(int maxAmmo)
    {
        this.maxAmmo = maxAmmo;
    }
    
    
}
