package control;
public class Bullet
{
    Screen screen;
    Sprite sprite;
    String type;
    double angle;
    double x;
    double y;
    boolean move = false;
    boolean stopped = false;
    Thread thread;
    BlockSystem control;
    String j;
    /** Creates a new instance of Bullet */
    public Bullet( double angl, double dx, double dy, Screen window, BlockSystem blocksys, String exclude, String i )
    {
        screen = window;
        angle = angl;
        x = dx;
        y = dy;
        j = i;
        type = exclude;
        sprite = screen.newSprite( "/images/bullet.png" );
        sprite.setPosition( dx, dy );
        sprite.setRadians( angle );
        sprite.setComment( "bullet" );
        control = blocksys;
        Chess.playSound( "/sound/bullet.wav" );
        
        Runnable run = new Runnable()
        {
            public void run()
            {
                while ( ! Bullet.this.stopped )
                {
                    try
                    {
                        Thread.sleep( 20 );
                    }
                    catch ( InterruptedException ex )
                    {
         
                    }
                    moveBullet();
                }
            }
        };
         
        thread = new Thread( run );
        thread.start();
         
    }
    public Bullet getBullet()
    {
        return this;
    }
    public void moveBullet()
    {
        x = x - Math.sin( angle ) * 20;
        y = y + Math.cos( angle ) * 20;
        sprite.setPosition( x, y );
        if ( screen.isGameOver() )
        {
            stopped = true;
            screen.destroySprite( sprite );
        }
        if ( control.isBlocked( x, y, type ) )
        {
            Sprite sp = control.getBlocker( x, y, j );
            if ( sp != null )
            {
                sp.getObj().hitByBullet( 5 );
            }
            stopped = true;
            screen.destroySprite( sprite );
        }
        if ( x > screen.getWidth() || x < 0 || y > screen.getHeight() || y < 0 )
        {
            stopped = true;
            screen.destroySprite( sprite );
        }
    }
    public boolean isStopped()
    {
        return this.stopped;
    }
    
}
