package control;
import java.awt.*;
import java.math.*;
import control.*;
import java.util.*;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.event.MouseInputAdapter;
public class BlockSystem
{
    Screen screen;
    LinkedList<Sprite> ref;
    Sprite temp;
    int i;
    Area overlap( Sprite s1, Sprite s2 )
    {
        Area a1= s1.getBounds();
        Area a2= s2.getBounds();
        Area overlap= new Area( a1 );
        overlap.intersect( a2 );
        return overlap;
    }
    public BlockSystem( Screen window )
    {
        ref = new LinkedList<Sprite>();
        screen = window;
    }
    public Sprite createBlocker( String image, double x, double y )
    {
        ref.add( screen.newSprite( image ) );
        temp = ref.getLast();
        temp.setAnchorPosition( 0, 0 );
        temp.setPosition( x, y );
        return temp;
    }
    public Sprite createBlocker( String image, double x, double y, String com )
    {
        ref.add( screen.newSprite( image ) );
        temp = ref.getLast();
        temp.setAnchorPosition( 0, 0 );
        temp.setPosition( x, y );
        temp.setComment( com );
        return temp;
    }
    public void removeBlocker( Sprite blocker )
    {
        ref.remove( blocker );
    }
    public void addBlocker( Sprite blocker )
    {
        ref.add( blocker );
    }
    public boolean spriteBlocked( Sprite blocker )
    {
        for ( Sprite t : ref )
        {
            if ( ! overlap( blocker, t ).isEmpty() )
            {
                if ( t.getComment() != "car" )
                {
                    return true;
                }
            }
        }
        return false;
    }
    public Sprite getBlocker( double dx, double dy, String type )
    {
        Sprite sp;
        if ( type == "null" )
        {
            sp = screen.getSpriteAt( (int) dx, (int) dy );
        }
        else
        {
            sp = screen.getSpriteAtWithComment( (int) dx, (int) dy, type );
        }
        
        return sp;
    }
    public Sprite getBlocker( double dx, double dy )
    {
        Sprite sp;
        sp = screen.getSpriteAt( (int) dx, (int) dy );
        return sp;
    }
    public boolean isBlocked( double dx, double dy, String exclude )
    {
        if ( ref.size() < 0 )
        {
            return false;
        }
        Sprite n;
        for ( int t = 0; t < ref.size(); t ++ ) // for ( Sprite t : ref )
        {
            n = ref.get( t );
            if ( n != null )
            {
                if ( n.overlaps( (int) dx, (int) dy ) )
                {
                    if ( ! n.getComment().equals( exclude ) )
                    {
                        return true;
                    }
                }
            }
            n = null;
        }
        return false;
    }
}
