/*
 * Barrel.java
 *
 * Created on June 15, 2007, 10:22 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package control;

/**
 *
 * @author Home
 */
public class Barrel implements Hurtable, LevelObject
{
    
    Screen screen;
    Sprite sprite;
    BlockSystem control;
    
    boolean stopped = false;
    
    int coins = 100;
    
    double hp = 50;
    
    /** Creates a new instance of Barrel */
    public Barrel( Screen window, BlockSystem ctrl, int dx, int dy )
    {
        control = ctrl;
        
        screen = window;
        
        sprite = screen.newSprite( "/images/barrel.png", dx, dy );
        sprite.setComment( "hittable" );
        sprite.setObj( this );
        control.addBlocker( sprite );
    }
    public boolean canDie()
    {
        return false;
    }
    public void killSelf()
    {
        screen.removeSprite( sprite );
        control.removeBlocker( sprite );
        stopped = true;
    }
    public boolean isDead()
    {
        return true;
    }
    public void hitByBullet( double damage )
    {
        hp -= damage;
        
        if ( hp < 0 )
        {
            hp = 0;
        }
        if ( hp == 0 && ! stopped )
        {
            stopped = true;
            sprite.setImage( "/images/explosion.gif" );
            Chess.sleep( 200 );
            control.removeBlocker( sprite );
            screen.destroySprite( sprite );
            screen.setCoins( screen.getCoins() + coins );
            sprite = null;
        }
    }
    
}
