import control.*;
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JFrame;
import java.awt.*;
import java.io.File;

public class FinalCar extends RunnableApplet
{
    // TODO: Class variables go here
    Screen window;
    BlockSystem control;
    Car carOne;
    Turret turret;
    TextPaintable lives;
    TextPaintable speed;
    TextPaintable health;
    TextPaintable ammo;
    LevelManager manager;
    
    LinkedList bullets;
    LinePaintable laser;
    double angle;
    
    
    int sleep;
    
    public void init()
    {
        window = Chess.newScreen( this );
        control = new BlockSystem( window );
        
        Font font = null;
        font = Font.decode( "sans-20" );
        
        carOne = new Car( window, control );
        
        control.createBlocker( "/images/gui.png", 0, 540 );
        
        laser = new LinePaintable( window, Color.GREEN, 0, 0, 0, 0 );
        manager = new LevelManager( window, control, carOne );
        
        
        
        window.setCoins( 500 );
        // new GarageUpgrade( window, control );
        
        health = new TextPaintable( window );
        health.setX( 56 );
        health.setY( 610 );
        
        ammo = new TextPaintable( window );
        ammo.setX( 236 );
        ammo.setY( 610 );
        
        lives = new TextPaintable( window );
        lives.setX( 745 );
        lives.setY( 610 );
        
        speed = new TextPaintable( window );
        speed.setX( 555 );
        speed.setY( 610 );
        
        
        
        health.setFont( font );
        ammo.setFont( font );
        lives.setFont( font );
        speed.setFont( font );
        
        carOne.setAmmo( 300 );
        carOne.setMaxAmmo( 300 );
        
        sleep = 0;
    } //init
    
    public void run()
    {
        while ( true )
        {
            // window.report( "(" + window.getRTMouseX() + ", " + window.getRTMouseY() + ") Down: " + window.isMouseDown() );
            health.setText( "" + (int) carOne.getHP() + "/" + (int) carOne.getMaxHP() );
            ammo.setText( "" + carOne.getAmmo() + "/" + carOne.getMaxAmmo() );
            speed.setText( "" + (int) carOne.getSpeed() );
            lives.setText( "" + carOne.getLives() );
            //showLaser();
            sleep ++;
            if ( window.keyDown( KeyEvent.VK_R ) )
            {
                if ( ! window.isPaused() )
                {
                    carOne.returnHome();
                }
            }
            if ( window.keyDown( KeyEvent.VK_LEFT ) )
            {
                if ( ! window.isPaused() )
                {
                    carOne.turnObj( - .1 );
                }
            }
            if ( window.keyDown( KeyEvent.VK_RIGHT ) )
            {
                if ( ! window.isPaused() )
                {
                    carOne.turnObj( .1 );
                }
            }
            if ( window.keyDown( KeyEvent.VK_UP ) )
            {
                if ( ! window.isPaused() )
                {
                    carOne.moveObj( carOne.getSpeed() );
                }
            }
            if ( window.keyDown( KeyEvent.VK_DOWN ) )
            {
                if ( ! window.isPaused() )
                {
                    carOne.moveObj( - 5 );
                }
            }
            
            if ( window.isMouseDown() )
            {
                if ( ! window.isPaused() )
                {
                    if ( sleep > 3 )
                    {
                        if ( carOne.getAmmo() > 0 )
                        {
                            angle = Math.atan2( carOne.getDX( 40 ) - window.getRTMouseX(), window.getRTMouseY() - carOne.getDY( 40 ) );
                            Bullet b = new Bullet( angle, carOne.getDX( 40 ), carOne.getDY( 40 ), window, control, "car", "hittable" );
                            sleep = 0;
                            carOne.setAmmo( carOne.getAmmo() - 1 );
                        }
                    }
                }
            }
            Chess.waitForNextFrame( 60 );
        }
    } //run
    
    public void showLaser()
    {
        angle = Math.atan2( carOne.getDX( 40 ) - window.getRTMouseX(), window.getRTMouseY() - carOne.getDY( 40 ) );
        boolean move = false;
        double dx = carOne.getDX( 40 );
        double dy = carOne.getDY( 40 );
        double tempx = dx;
        double tempy = dy;
        
        double tox = 0;
        double toy = 0;
        
        boolean temp = false;
        
        tempx = tempx - Math.sin( angle ) * 40;
        tempy = tempy + Math.cos( angle ) * 40;
        
        while ( ! move )
        {
            tempx = tempx - Math.sin( angle ) * 1;
            tempy = tempy + Math.cos( angle ) * 1;
            
            if ( control.isBlocked( tempx, tempy, "hittable" ) )
            {
                temp = true;
                move = true;
                tox = tempx;
                toy = tempy;
            }
            else if ( control.isBlocked( tempx, tempy, "" ) )
            {
                temp = false;
                move = true;
                tox = tempx;
                toy = tempy;
            }
            
            if ( tempx < 0 || tempx > window.getWidth() || tempy < 0 || tempy > window.getHeight() )
            {
                temp = false;
                move = true;
                tox = tempx;
                toy = tempy;
            }
        }
        
        laser.repositionLine( carOne.getDX( 40 ), carOne.getDY( 40 ), tox, toy );
    }
    /**
     *  For testing within NetBeans, we define a main method.  This is
     *  ignored when a web page uses the applet.  Here is the code you should
     *  have in your web page:
     *    <applet archive="CarDestiny.jar" code="CarDestiny" width="600" height="400" ></applet>
     *  The file CHESS.jar is found in the folder "dist", and should be
     *  put next to the html file.
     */
    public static void main( String[] args )
    {
        JFrame frame = new JFrame( "FinalCar" );
        
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
        Applet applet = new FinalCar();
        Dimension appletDimension = new Dimension( 850, 700 );
        applet.setMinimumSize( appletDimension );
        applet.setPreferredSize( appletDimension );
        frame.setContentPane( applet );
        frame.pack();
        frame.setVisible( true );
        applet.init();
        applet.start();
    } //main
} //class
