/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Screen;
import control.Sprite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Stack;

public class Turtle
extends Sprite {
    Stack stateStack = new Stack();
    boolean penDown = true;
    int cycleDelay;
    Color color = Color.blue.darker().darker();
    Stroke stroke = new BasicStroke(1.0f);
    Font font = new Font("SansSerif", 0, 12);

    public Turtle(Screen graph) {
        super("/chess/turtle.png", graph, 200, 200, 0.0, 14.0);
        this.home();
        this.fast();
    }

    public void home() {
        this.setPosition(200, 200);
        this.setOrientation(-90.0);
        this.graph.repaint();
    }

    public void forward(double i) {
        double x0 = this.x;
        double y0 = this.y;
        double x2 = this.x + Math.cos(this.angle) * i;
        double y2 = this.y + Math.sin(this.angle) * i;
        this.x = x2;
        this.y = y2;
        if (this.penDown) {
            this.graph.line((int)x0, (int)y0, (int)this.x, (int)this.y, this.color, this.stroke);
        }
        this.setPosition(x2, y2);
        this.graph.repaint();
        this.pause();
    }

    public void back(double i) {
        this.forward(-1.0 * i);
    }

    public void right(double i) {
        this.angle += i * Math.PI / 180.0;
        this.resetTransform();
        this.graph.repaint();
        this.pause();
    }

    public void left(double i) {
        this.angle -= i * Math.PI / 180.0;
        this.resetTransform();
        this.graph.repaint();
        this.pause();
    }

    private AffineTransform getAffineTransform() {
        AffineTransform result = AffineTransform.getTranslateInstance(this.x, this.y);
        result.rotate(this.angle);
        return result;
    }

    public void circle(int i) {
        double x2 = this.x + Math.cos(this.angle) * (double)i;
        double y2 = this.y + Math.sin(this.angle) * (double)i;
        if (this.penDown) {
            this.graph.circle((int)x2, (int)y2, i, this.color, this.stroke);
        }
        this.setPosition(x2 += Math.cos(this.angle) * (double)i, y2 += Math.sin(this.angle) * (double)i);
        this.graph.repaint();
        this.pause();
    }

    public void text(String text) {
        Graphics2D g = this.graph.getGraphics();
        g.setColor(this.color);
        g.setStroke(this.stroke);
        g.setFont(this.font);
        g.setTransform(this.getAffineTransform());
        g.drawString(text, 0, 0);
        int w = g.getFontMetrics().stringWidth(text);
        double x2 = this.x + Math.cos(this.angle) * (double)w;
        double y2 = this.y + Math.sin(this.angle) * (double)w;
        this.setPosition(x2, y2);
        this.graph.repaint();
        this.pause();
    }

    public void image(String filename) {
        Graphics2D g = this.graph.getGraphics();
        g.setColor(this.color);
        g.setStroke(this.stroke);
        g.setTransform(this.getAffineTransform());
        Image i = this.graph.getImage(filename);
        g.drawImage(i, 0, 0, null);
        int w = i.getWidth(null);
        double x2 = this.x + Math.cos(this.angle) * (double)w;
        double y2 = this.y + Math.sin(this.angle) * (double)w;
        this.setPosition(x2, y2);
        this.graph.repaint();
        this.pause();
    }

    public void image(String filename, int length) {
        Graphics2D g = this.graph.getGraphics();
        g.setColor(this.color);
        g.setStroke(this.stroke);
        g.setTransform(this.getAffineTransform());
        Image i = this.graph.getImage(filename);
        int h = i.getHeight(null);
        int w = i.getWidth(null);
        g.drawImage(i, 0, 0, w * length / h, length, null);
        double x2 = this.x + Math.cos(this.angle) * (double)length;
        double y2 = this.y + Math.sin(this.angle) * (double)length;
        this.setPosition(x2, y2);
        this.graph.repaint();
        this.pause();
    }

    public void penUp() {
        this.penDown = false;
        this.graph.repaint();
        this.pause();
    }

    public void penDown() {
        this.penDown = true;
        this.graph.repaint();
        this.pause();
    }

    public void slow() {
        this.cycleDelay = 50;
    }

    public void fast() {
        this.cycleDelay = 5;
    }

    public void ultraFast() {
        this.cycleDelay = 0;
    }

    public void push() {
        State state = new State();
        state.x = this.x;
        state.y = this.y;
        state.angle = this.angle;
        this.stateStack.push(state);
        this.pause();
    }

    public void pop() {
        State state = (State)this.stateStack.pop();
        this.x = state.x;
        this.y = state.y;
        this.angle = state.angle;
        this.resetTransform();
        this.graph.repaint();
        this.pause();
    }

    private void pause() {
        this.graph.repaint();
        if (this.cycleDelay > 0) {
            try {
                Thread.sleep(this.cycleDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static Color getHSVColor(double h, double s, double v) {
        double r = -99999.0;
        double g = -99999.0;
        double b = -99999.0;
        if (s == 0.0) {
            r = v;
            g = v;
            b = v;
        } else {
            double hTemp = h % 360.0;
            int i = (int)Math.floor(hTemp /= 60.0);
            double f = hTemp - (double)i;
            double p = v * (1.0 - s);
            double q = v * (1.0 - s * f);
            double t = v * (1.0 - s * (1.0 - f));
            switch (i) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: {
                    r = v;
                    g = p;
                    b = q;
                }
            }
        }
        return new Color((float)r, (float)g, (float)b, 1.0f);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setColor(int hue) {
        if ((hue %= 360) < 0) {
            hue += 360;
        }
        this.setHSVColor(hue, 1.0, 1.0);
    }

    public void setHSVColor(double hue, double sat, double value) {
        this.color = Turtle.getHSVColor((float)hue, (float)sat, (float)value);
    }

    public void setRGBColor(double red, double green, double blue) {
        this.color = new Color((float)red, (float)green, (float)blue, 1.0f);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontSize(double pointSize) {
        this.font = this.font.deriveFont((float)pointSize);
    }

    public void setLineWidth(double width) {
        this.stroke = new BasicStroke((float)width);
    }

    class State {
        double angle;
        double x;
        double y;

        State() {
        }
    }
}

