/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BlockSystem;
import control.Bullet;
import control.Car;
import control.Chess;
import control.Hurtable;
import control.LevelObject;
import control.LinePaintable;
import control.Screen;
import control.Sprite;
import control.TextPaintable;
import java.awt.Color;
import java.awt.Font;

public class Turret
implements Hurtable,
LevelObject {
    boolean stopped = false;
    double dangle;
    double angle;
    Car car;
    Screen screen;
    double x;
    double y;
    Sprite sprite;
    BlockSystem control;
    LinePaintable laser;
    TextPaintable healthText;
    double tox;
    double toy;
    double hp = 500.0;
    int count = 0;
    boolean gold = false;
    int coins = 1000;

    public Turret(Car n, Screen window, double dx, double dy, BlockSystem blocksys, boolean go) {
        this.gold = true;
        this.car = n;
        this.screen = window;
        this.x = dx;
        this.y = dy;
        this.angle = 0.0;
        this.control = blocksys;
        this.hp = 1500.0;
        this.sprite = this.screen.newSprite("/images/turret_gold.png");
        this.sprite.setPosition(dx, dy);
        this.sprite.setObj(this);
        this.sprite.setComment("hittable");
        this.sprite.setAnchorPosition(18.0, 16.0);
        this.laser = new LinePaintable(this.screen, Color.GREEN, 0.0, 0.0, 0.0, 0.0);
        this.healthText = new TextPaintable(this.screen);
        Font font = Font.decode("sans-10");
        this.healthText.setFont(font);
        this.healthText.setX(dx - 10.0);
        this.healthText.setY(dy - 40.0);
        this.healthText.setColor(Color.YELLOW);
        this.healthText.setText("18");
        this.control.addBlocker(this.sprite);
        Runnable run = new Runnable(){

            public void run() {
                while (!Turret.this.stopped) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Turret.this.shootTurret();
                    Turret.this.checkMouseOver();
                }
            }
        };
        new Thread(run).start();
    }

    public Turret(Car n, Screen window, double dx, double dy, BlockSystem blocksys) {
        this.car = n;
        this.screen = window;
        this.x = dx;
        this.y = dy;
        this.angle = 0.0;
        this.control = blocksys;
        this.sprite = this.screen.newSprite("/images/turret.png");
        this.sprite.setPosition(dx, dy);
        this.sprite.setObj(this);
        this.sprite.setComment("hittable");
        this.sprite.setAnchorPosition(18.0, 16.0);
        this.laser = new LinePaintable(this.screen, Color.RED, 0.0, 0.0, 0.0, 0.0);
        this.healthText = new TextPaintable(this.screen);
        Font font = Font.decode("sans-10");
        this.healthText.setFont(font);
        this.healthText.setX(dx - 10.0);
        this.healthText.setY(dy - 40.0);
        this.healthText.setColor(Color.LIGHT_GRAY);
        this.healthText.setText("18");
        this.control.addBlocker(this.sprite);
        Runnable run = new Runnable(){

            public void run() {
                while (!Turret.this.stopped) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Turret.this.shootTurret();
                    Turret.this.checkMouseOver();
                }
            }
        };
        new Thread(run).start();
    }

    public boolean shootTurret() {
        if (this.screen.isGameOver()) {
            this.stopped = true;
            this.screen.clear();
            return false;
        }
        this.angle = Math.atan2(this.x - (double)this.car.getX(), (double)this.car.getY() - this.y);
        this.sprite.setRadians(this.angle);
        boolean move = false;
        double dx = this.x - Math.sin(this.angle) * 20.0;
        double dy = this.y + Math.cos(this.angle) * 20.0;
        double tempx = dx;
        double tempy = dy;
        boolean temp = false;
        tempx -= Math.sin(this.angle) * 20.0;
        tempy += Math.cos(this.angle) * 20.0;
        while (!move) {
            if (this.control.isBlocked(tempx -= Math.sin(this.angle) * 1.0, tempy += Math.cos(this.angle) * 1.0, "car")) {
                temp = true;
                move = true;
                this.tox = tempx;
                this.toy = tempy;
            } else if (this.control.isBlocked(tempx, tempy, "")) {
                temp = false;
                move = true;
                this.tox = tempx;
                this.toy = tempy;
            }
            if (!(tempx < 0.0 || tempx > (double)this.screen.getWidth() || tempy < 0.0) && !(tempy > (double)this.screen.getHeight())) continue;
            temp = false;
            move = true;
            this.tox = tempx;
            this.toy = tempy;
        }
        this.laser.repositionLine(dx, dy, this.tox, this.toy);
        ++this.count;
        if (this.count == 5) {
            this.count = 0;
        } else {
            temp = true;
        }
        this.angle += Chess.getRan(-0.1, 0.1);
        if (!temp && !this.screen.isPaused()) {
            new Bullet(this.angle, dx, dy, this.screen, this.control, "hittable", "car");
        }
        return false;
    }

    public boolean canDie() {
        return true;
    }

    public boolean isDead() {
        return this.hp == 0.0;
    }

    public void killSelf() {
    }

    public void hitByBullet(double damage) {
        this.hp -= damage;
        if (this.hp < 0.0) {
            this.hp = 0.0;
        }
        if (this.hp == 0.0 && !this.stopped) {
            this.stopped = true;
            this.sprite.setImage("/images/explosion.gif");
            Chess.sleep(200);
            this.control.removeBlocker(this.sprite);
            this.screen.destroySprite(this.sprite);
            this.laser.repositionLine(-1.0, -1.0, -1.0, -1.0);
            this.healthText.hide();
            this.screen.setCoins(this.screen.getCoins() + this.coins);
        }
    }

    public void checkMouseOver() {
        double dy;
        double dx = this.screen.getRTMouseX();
        if (this.sprite.overlaps((int)dx, (int)(dy = this.screen.getRTMouseY()))) {
            this.healthText.reveal();
            this.healthText.setText("" + (int)this.hp);
        } else {
            this.healthText.hide();
        }
    }
}

