/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Paintable;
import control.Screen;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class TextPaintable
implements Paintable {
    String comment = "";
    Screen screen;
    boolean hidden = false;
    private String text = "text";
    private double x;
    private double y;
    private Color color = Color.BLACK;
    private int size = 12;
    private Font font;

    public TextPaintable(Screen win) {
        this.screen = win;
        this.screen.addPaintable(this);
    }

    public TextPaintable(Screen win, String com) {
        this.screen = win;
        this.comment = com;
        this.screen.addPaintable(this);
    }

    public void paint(Graphics2D g) {
        if (!this.comment.equals("end") && this.screen.isGameOver()) {
            this.setText("");
        }
        if (this.hidden) {
            this.setText("");
        }
        g.setColor(this.color);
        g.setFont(this.font);
        g.drawString(this.text, (int)this.x, (int)this.y);
    }

    public void hide() {
        this.hidden = true;
    }

    public void reveal() {
        this.hidden = false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

