/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Chess;
import control.Hurtable;
import control.Screen;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.ImageIcon;

public class Sprite {
    double angle;
    double x;
    double y;
    double cmx;
    double cmy;
    int width;
    int height;
    String comment = "";
    Hurtable obj;
    AffineTransform transform;
    int imageWidth;
    int imageHeight;
    boolean isHidden;
    Screen graph;
    private Image image;
    Area bounds;

    public void setObj(Hurtable ob) {
        this.obj = ob;
    }

    public Hurtable getObj() {
        return this.obj;
    }

    protected Sprite(String filename, Screen graph) {
        this(filename, graph, 0, 0, -99.0, -99.0);
    }

    protected Sprite(String filename, Screen graph, int x, int y, double cmx, double cmy) {
        URL ff;
        this.graph = graph;
        this.x = x;
        this.y = y;
        this.angle = 0.0;
        this.isHidden = false;
        if (!filename.startsWith("/")) {
            filename = "/" + filename;
        }
        if ((ff = Chess.findResource(filename)) == null) {
            throw new RuntimeException("unable to find file " + filename);
        }
        this.image = new ImageIcon(ff).getImage();
        this.imageWidth = this.image.getWidth(graph.panel);
        this.imageHeight = this.image.getHeight(graph.panel);
        if (cmx == -99.0 || cmy == -99.0) {
            cmx = (double)this.imageWidth / 2.0;
            cmy = (double)this.imageHeight / 2.0;
        }
        this.cmx = cmx;
        this.cmy = cmy;
        this.bounds = new Area(new Rectangle(0, 0, this.imageWidth, this.imageHeight));
        this.resetTransform();
    }

    protected void paint(Graphics g1) {
        if (!this.isHidden) {
            Graphics2D g = (Graphics2D)g1;
            AffineTransform at0 = g.getTransform();
            g.transform(this.transform);
            g.drawImage(this.image, 0, 0, this.graph.panel);
            g.setTransform(at0);
            g.setColor(new Color(1.0f, 0.0f, 0.0f, 0.2f));
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.resetTransform();
        this.graph.repaint();
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
        this.resetTransform();
        this.graph.repaint();
    }

    public void setAnchorPosition(double x, double y) {
        this.cmx = x;
        this.cmy = y;
        this.resetTransform();
        this.graph.repaint();
    }

    public void setImage(String filename) {
        URL ff = Chess.findResource(filename);
        if (ff == null) {
            throw new RuntimeException("unable to find file " + filename);
        }
        this.image = new ImageIcon(ff).getImage();
        this.graph.repaint();
    }

    public int getPositionX() {
        return (int)this.x;
    }

    public int getPositionY() {
        return (int)this.y;
    }

    public void setOrientation(double angle) {
        this.angle = angle * Math.PI / 180.0;
        this.resetTransform();
        this.graph.repaint();
    }

    public int getOrientation() {
        return (int)(this.angle * 180.0 / Math.PI);
    }

    public double getRadians() {
        return this.angle;
    }

    protected void resetTransform() {
        this.transform = AffineTransform.getTranslateInstance(this.x, this.y);
        this.transform.rotate(this.angle);
        this.transform.translate(-this.cmx, -this.cmy);
    }

    public void hide() {
        this.isHidden = true;
        this.graph.repaint();
    }

    public void reveal() {
        this.isHidden = false;
        this.graph.repaint();
    }

    public boolean overlaps(int x, int y) {
        try {
            Point2D p = new Point2D.Double(x, y);
            p = this.transform.createInverse().transform(p, p);
            Rectangle boundary = new Rectangle(this.image.getWidth(null), this.image.getHeight(null));
            return boundary.contains(p);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBounds(Area a) {
        this.bounds = a;
    }

    public void setRadians(double radians) {
        this.angle = radians;
        this.resetTransform();
        this.graph.repaint();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int ht) {
        this.height = ht;
    }

    public void setWidth(int wd) {
        this.width = wd;
    }

    public void setComment(String newcomment) {
        this.comment = newcomment;
    }

    public String getComment() {
        return this.comment;
    }

    public Area getBounds() {
        GeneralPath path = new GeneralPath(this.bounds);
        path.transform(this.transform);
        Area a = new Area(path);
        return a;
    }
}

