/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Car;
import control.Chess;
import control.Paintable;
import control.Sprite;
import control.Turtle;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class Screen
extends JFrame {
    private JFrame frame;
    protected ScreenPanel panel;
    private JLabel label;
    int width;
    int height;
    List text = new ArrayList();
    int mouseX = -999;
    int mouseY = -999;
    boolean waitingForClick = false;
    boolean mouseWasClicked = false;
    boolean mousePressed = false;
    boolean pause = false;
    boolean[] keys = new boolean[525];
    boolean mouseDown = false;
    LinkedList keyEvents;
    LinkedList keyDown;
    double mousex2;
    double mousey2;
    private int paintCount = 0;
    private int repaintCount = 0;
    private Image overlayImage = null;
    private List<Paintable> paintables = new ArrayList<Paintable>();
    private Stroke stroke = new BasicStroke(1.0f);
    private Color color = Color.black;
    private Font font = Font.decode("PLAIN");
    private boolean gameOver;
    private int coins;
    private Car car;
    private boolean paused;
    private int frameRate = 40;

    public void addPaintable(Paintable p) {
        this.paintables.add(p);
    }

    protected Screen(int width, int height, JApplet applet) {
        this.width = width;
        this.height = height;
        if (applet == null) {
            this.frame = new JFrame("Screen");
        }
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        this.panel = new ScreenPanel(this);
        this.panel.setPreferredSize(new Dimension(width, height));
        content.add((Component)this.panel, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new JMenuItem(this.panel.getSaveAsPngAction()));
        if (applet == null) {
            menu.add(new JMenuItem(this.getExitAction()));
        }
        menuBar.add(menu);
        content.add((Component)menuBar, "North");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.label = new JLabel("");
        this.label.setPreferredSize(new Dimension(200, 20));
        controlPanel.add(this.label);
        content.add((Component)controlPanel, "South");
        if (applet != null) {
            applet.getContentPane().add(content);
            applet.validate();
        } else {
            this.frame.getContentPane().add(content);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowGainedFocus(WindowEvent e) {
                    Screen.this.panel.requestFocus();
                }

                public void windowOpened(WindowEvent e) {
                    Screen.this.panel.requestFocus();
                }
            });
            this.frame.pack();
            this.frame.setVisible(true);
            this.frame.setDefaultCloseOperation(3);
        }
        this.keyEvents = new LinkedList();
        this.keyDown = new LinkedList();
    }

    protected Screen() {
        this(400, 300, null);
    }

    public boolean isMouseDown() {
        return this.mouseDown;
    }

    public Turtle newTurtle() {
        Turtle result = new Turtle(this);
        this.panel.sprites.add(result);
        this.repaint();
        return result;
    }

    public Sprite newSprite(String filename) {
        Sprite result = new Sprite(filename, this);
        this.panel.sprites.add(result);
        this.repaint();
        return result;
    }

    public double getRTMouseX() {
        return this.mousex2;
    }

    public double getRTMouseY() {
        return this.mousey2;
    }

    public Sprite newSprite(String filename, int x, int y) {
        Sprite result = new Sprite(filename, this, x, y, -99.0, -99.0);
        this.panel.sprites.add(result);
        this.repaint();
        return result;
    }

    public void addSprite(Sprite sprite) {
        this.panel.sprites.add(sprite);
        this.repaint();
    }

    public void removeSprite(Sprite sprite) {
        this.panel.sprites.remove(sprite);
        this.repaint();
    }

    public void removeSprite(final Sprite sprite, final int afterMillis) {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(afterMillis);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                Screen.this.removeSprite(sprite);
            }
        };
        new Thread(run).start();
    }

    public void destroySprite(Sprite sprite) {
        this.removeSprite(sprite);
    }

    public Graphics2D getGraphics() {
        Graphics2D g = (Graphics2D)this.panel.image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.color);
        g.setStroke(this.stroke);
        g.setFont(this.font);
        return g;
    }

    public void repaint() {
        if (this.pause) {
            return;
        }
        ++this.repaintCount;
        this.panel.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean keyDown(int keyCode) {
        return this.keys[keyCode];
    }

    public boolean mouseDown() {
        return this.mouseDown;
    }

    public int getWidth() {
        return this.panel.getWidth();
    }

    public int getHeight() {
        return this.panel.getHeight();
    }

    public void setLineThickness(double thickness) {
        this.stroke = new BasicStroke((float)thickness);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public void setFontSize(double pointSize) {
        this.font = this.font.deriveFont((float)pointSize);
    }

    void circle(int x, int y, int radius, Color color, Stroke stroke) {
        Graphics2D g = this.getGraphics();
        g.setColor(color);
        g.setStroke(stroke);
        g.drawOval(x - radius, y - radius, 2 * radius, 2 * radius);
        this.repaint();
    }

    void line(int x1, int y1, int x2, int y2, Color color, Stroke stroke) {
        Graphics2D g = this.getGraphics();
        g.setColor(color);
        g.setStroke(stroke);
        g.drawLine(x1, y1, x2, y2);
        this.repaint();
    }

    public void drawCircle(int x, int y, int radius) {
        Graphics2D g = this.getGraphics();
        g.drawOval(x - radius, y - radius, 2 * radius, 2 * radius);
        this.repaint();
    }

    public void drawCircle(double x, double y, double radius) {
        Graphics2D g = this.getGraphics();
        g.drawOval((int)(x - radius), (int)(y - radius), (int)(2.0 * radius), (int)(2.0 * radius));
        this.repaint();
    }

    public void fillCircle(int x, int y, int radius) {
        Graphics2D g = this.getGraphics();
        g.fillOval(x - radius, y - radius, 2 * radius, 2 * radius);
        this.repaint();
    }

    public void fillCircle(double x, double y, double radius) {
        Graphics2D g = this.getGraphics();
        g.fillOval((int)(x - radius), (int)(y - radius), (int)(2.0 * radius), (int)(2.0 * radius));
        this.repaint();
    }

    public void drawRect(int x, int y, int height, int width) {
        Graphics2D g = this.getGraphics();
        g.drawRect(x, y, height, width);
        this.repaint();
    }

    public void drawRect(double x, double y, double height, double width) {
        this.drawRect((int)x, (int)y, (int)height, (int)width);
    }

    public void fillRect(int x, int y, int width, int height) {
        Graphics2D g = this.getGraphics();
        g.fillRect(x, y, width, height);
        this.repaint();
    }

    public void fillRect(double x, double y, double width, double height) {
        this.fillRect((int)x, (int)y, (int)width, (int)height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Graphics2D g = this.getGraphics();
        g.drawLine(x1, y1, x2, y2);
        this.repaint();
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void drawString(String s, double x, double y) {
        Graphics2D g = this.getGraphics();
        g.drawString(s, (float)x, (float)y);
        this.repaint();
    }

    protected Image getImage(String resource) {
        URL url = Chess.findResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("file does not exist: " + resource);
        }
        ImageIcon icon = new ImageIcon(url);
        return icon.getImage();
    }

    public void drawImage(String filename, int x, int y) {
        Image i = this.getImage(filename);
        this.getGraphics().drawImage(i, x, y, null);
        this.repaint();
    }

    public void drawImage(String filename, double x, double y) {
        this.drawImage(filename, (int)x, (int)y);
    }

    public void waitForMouseClick() {
        this.waitingForClick = true;
        this.label.setText("  waiting for mouse click");
        this.panel.setCursor(new Cursor(1));
        while (this.waitingForClick) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.panel.setCursor(new Cursor(0));
    }

    public boolean mouseWasClicked() {
        return this.mouseWasClicked;
    }

    public int getMouseX() {
        this.mouseWasClicked = false;
        return this.mouseX;
    }

    public int getMouseY() {
        this.mouseWasClicked = false;
        return this.mouseY;
    }

    public void waitForKey() {
        this.label.setText("  waiting for key stroke");
        while (this.keyEvents.size() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getKeyCode() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.keyEvents.size() == 0) {
            return 0;
        }
        KeyEvent e = (KeyEvent)this.keyEvents.remove(0);
        return e.getKeyCode();
    }

    public char getKey() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.keyEvents.size() == 0) {
            return '\u0000';
        }
        KeyEvent e = (KeyEvent)this.keyEvents.remove(0);
        return e.getKeyChar();
    }

    public Sprite getSpriteAt(int x, int y) {
        for (int i = this.panel.sprites.size() - 1; i >= 0; --i) {
            Sprite s = (Sprite)this.panel.sprites.get(i);
            if (!s.overlaps(x, y)) continue;
            return s;
        }
        return null;
    }

    public LinkedList getAllSprites() {
        LinkedList list = new LinkedList();
        for (int a = 0; a < this.panel.sprites.size() - 1; ++a) {
            list.add(this.panel.sprites.get(a));
        }
        return list;
    }

    public LinkedList getAllPaintables() {
        LinkedList<Paintable> list = new LinkedList<Paintable>();
        for (int a = 0; a < this.paintables.size() - 1; ++a) {
            list.add(this.paintables.get(a));
        }
        return list;
    }

    public Sprite getSpriteAtWithComment(int x, int y, String comment) {
        for (int i = this.panel.sprites.size() - 1; i >= 0; --i) {
            Sprite s = (Sprite)this.panel.sprites.get(i);
            if (!s.overlaps(x, y) || s.getComment() == null || !s.getComment().equals(comment)) continue;
            return s;
        }
        return null;
    }

    public void clear(Color color) {
        Graphics2D g = this.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, this.panel.getWidth(), this.panel.getHeight());
        this.repaint();
    }

    public void clear() {
        this.clear(Color.white);
    }

    public Color getPixelColor(double x, double y) {
        return this.getPixelColor((int)x, (int)y);
    }

    public Color getPixelColor(int x, int y) {
        try {
            int argb = this.panel.image.getRGB(x, y);
            return new Color(argb, true);
        }
        catch (IndexOutOfBoundsException ex) {
            return Color.gray;
        }
    }

    public void saveAsPng() {
        this.panel.saveAsPng();
    }

    private Action getExitAction() {
        return new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
    }

    public void report(String message) {
        this.label.setText(message);
    }

    public void addMouseInputAdapter(MouseInputAdapter mouseInputAdapter) {
        this.panel.addMouseListener(mouseInputAdapter);
        this.panel.addMouseMotionListener(mouseInputAdapter);
    }

    public void setOverlayImage(Image overlay) {
        this.overlayImage = overlay;
        this.repaint();
    }

    public void setOverlayImage(String filename) {
        this.setOverlayImage(this.getImage(filename));
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void setGameOver(boolean gameOver) {
        this.gameOver = gameOver;
    }

    public int getCoins() {
        return this.coins;
    }

    public void setCoins(int coins) {
        this.coins = coins;
    }

    public Car getCar() {
        return this.car;
    }

    public void setCar(Car car) {
        this.car = car;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    private class ScreenPanel
    extends JPanel {
        private BufferedImage image;
        private ArrayList sprites;
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent e) {
                Screen.this.mousePressed = true;
                Screen.this.mouseX = e.getX();
                Screen.this.mouseY = e.getY();
                if (Screen.this.keyDown(32)) {
                    Screen.this.label.setText(" x:" + Screen.this.mouseX + " y:" + Screen.this.mouseY);
                }
                Screen.this.waitingForClick = false;
                Screen.this.mouseWasClicked = true;
                ScreenPanel.this.requestFocus();
            }

            public void mouseReleased(MouseEvent e) {
                Screen.this.mouseDown = false;
                Screen.this.mousePressed = false;
            }

            public void mousePressed(MouseEvent e) {
                Screen.this.mouseDown = true;
            }
        };

        private ScreenPanel(Screen screen2) {
            this.image = new BufferedImage(Screen.this.width, Screen.this.height, 2);
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, Screen.this.width, Screen.this.height);
            this.sprites = new ArrayList();
            this.addMouseListener(this.mouseAdapter);
            this.addKeyListener(this.getKeyListener());
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    Screen.this.mousex2 = e.getPoint().getX();
                    Screen.this.mousey2 = e.getPoint().getY();
                }

                public void mouseDragged(MouseEvent e) {
                    Screen.this.mousex2 = e.getPoint().getX();
                    Screen.this.mousey2 = e.getPoint().getY();
                }
            });
        }

        public void paint(Graphics g1) {
            super.paint(g1);
            Screen.this.paintCount++;
            Graphics2D g = (Graphics2D)g1;
            if (this.image != null) {
                g.drawImage((Image)this.image, 0, 0, this);
            }
            for (int i = 0; i < this.sprites.size(); ++i) {
                ((Sprite)this.sprites.get(i)).paint(g);
            }
            if (Screen.this.overlayImage != null) {
                g.drawImage(Screen.this.overlayImage, 0, 0, this);
            }
            for (Paintable p : Screen.this.paintables) {
                p.paint((Graphics2D)g1);
            }
        }

        private KeyListener getKeyListener() {
            return new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    Screen.this.keyEvents.add(e);
                    Screen.this.keys[e.getKeyCode()] = true;
                }

                public void keyReleased(KeyEvent e) {
                    Screen.this.keyEvents.remove(e);
                    Screen.this.keys[e.getKeyCode()] = false;
                }
            };
        }

        public void saveAsPng() {
            File f = null;
            try {
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
                ImageWriter writer = writers.next();
                JFileChooser jf = new JFileChooser();
                jf.setSelectedFile(new File("drawing.png"));
                int i = jf.showSaveDialog(this);
                if (i == 0) {
                    f = jf.getSelectedFile();
                    ImageOutputStream ios = ImageIO.createImageOutputStream(f);
                    writer.setOutput(ios);
                    BufferedImage simage = new BufferedImage(Screen.this.width, Screen.this.height, 2);
                    this.paint(simage.getGraphics());
                    writer.write(simage);
                }
            }
            catch (IOException e) {
                if (f == null) {
                    JOptionPane.showConfirmDialog(this, "Unable to write to file " + f);
                }
                JOptionPane.showConfirmDialog(this, "Unable to write gif, here's the exception: " + e);
            }
        }

        public Action getSaveAsPngAction() {
            AbstractAction result = new AbstractAction("Save as .png"){

                public void actionPerformed(ActionEvent e) {
                    ScreenPanel.this.saveAsPng();
                }
            };
            return result;
        }
    }
}

