/*
 * Decompiled with CFR 0.152.
 */
package control;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class MusicalInstrument {
    MidiChannel mc;
    Sequence sequence;
    Synthesizer synthesizer;
    Instrument[] instruments;
    MidiChannel[] midiChannels;
    static int allocatedChannels = 0;

    public MusicalInstrument() {
        this.open();
    }

    private void open() {
        try {
            if (this.synthesizer == null && (this.synthesizer = MidiSystem.getSynthesizer()) == null) {
                System.out.println("getSynthesizer() failed!");
                return;
            }
            this.synthesizer.open();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Soundbank sb = this.synthesizer.getDefaultSoundbank();
        if (sb != null) {
            this.instruments = this.synthesizer.getDefaultSoundbank().getInstruments();
            System.out.println(this.instruments[0].getName());
        }
        this.midiChannels = this.synthesizer.getChannels();
        if (allocatedChannels == this.midiChannels.length) {
            allocatedChannels = 0;
        }
        this.mc = this.midiChannels[allocatedChannels++];
        this.setInstrumentType(0);
    }

    public void setInstrumentType(int i) {
        i = i > this.instruments.length - 1 ? this.instruments.length - 1 : i;
        Instrument instrument = this.instruments[i];
        this.synthesizer.loadInstrument(instrument);
        this.mc.programChange(instrument.getPatch().getProgram());
    }

    public List getInstrumentTypes() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.instruments.length; ++i) {
            result.add(this.instruments[i].getName());
        }
        return result;
    }

    public void setInstrumentType(String name) {
        int i;
        for (i = 0; i < this.instruments.length && !this.instruments[i].getName().equalsIgnoreCase(name); ++i) {
        }
        i = i > this.instruments.length - 1 ? this.instruments.length - 1 : i;
        Instrument instrument = this.instruments[i];
        this.synthesizer.loadInstrument(instrument);
        this.mc.programChange(instrument.getPatch().getProgram());
    }

    public void playNote(final int noteNumber, int velocity, final int millis) {
        this.mc.noteOn(noteNumber, velocity);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                MusicalInstrument.this.mc.noteOff(noteNumber);
            }
        };
        new Thread(run).start();
    }
}

