/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Barrel;
import control.BlockSystem;
import control.ButtonBuilder;
import control.Car;
import control.DefaultBuilding;
import control.GarageButton;
import control.LevelObject;
import control.Screen;
import control.Turret;
import java.util.LinkedList;

public class LevelManager
implements ButtonBuilder {
    LinkedList levelOne;
    LinkedList levelTwo;
    LinkedList levelThree;
    BlockSystem control;
    Screen screen;
    Car car;
    GarageButton nextL;
    int currentLevel;

    public LevelManager(Screen s, BlockSystem b, Car c) {
        this.screen = s;
        this.control = b;
        this.car = c;
        this.levelOne = new LinkedList();
        this.levelTwo = new LinkedList();
        this.levelThree = new LinkedList();
        this.setLevel(1);
        this.drawLevel(this.getCurrentLevel());
        Runnable run = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LevelManager.this.callLoop();
                }
            }
        };
        new Thread(run).start();
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void callLoop() {
        this.checkLevel(this.getCurrentLevel());
    }

    public boolean checkLevel(int level) {
        LinkedList list = this.getList(level);
        for (Object a : list) {
            LevelObject obj = (LevelObject)a;
            if (obj.isDead() || !obj.canDie()) continue;
            return false;
        }
        if (this.nextL == null) {
            this.showLevelButton();
        }
        return true;
    }

    public void showLevelButton() {
        this.nextL = new GarageButton(this.screen, 375.0, 570.0, "/images/buttons/button_nextlevel.png", "/images/buttons/button_nextlevel_selected.png", this, "nextlevel");
    }

    public void buttonDown(String c) {
        if (c == "nextlevel") {
            this.nextLevel();
            this.nextL.destroyButton();
            this.nextL = null;
        }
    }

    public void nextLevel() {
        if (this.getCurrentLevel() < 3) {
            LinkedList list = this.getList(this.getCurrentLevel());
            for (Object a : list) {
                LevelObject obj = (LevelObject)a;
                obj.killSelf();
            }
            this.car.setAmmo(this.car.getMaxAmmo());
            this.car.setHP(this.car.getMaxHP());
            this.setLevel(this.getCurrentLevel() + 1);
            this.drawLevel(this.getCurrentLevel());
        }
    }

    public void drawLevelOne() {
        this.addObject(new DefaultBuilding(this.screen, this.control, "/images/building.png", 650.0, 0.0), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 590, 280), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 570, 315), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 580, 340), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 320, 400), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 348, 390), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 376, 380), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 404, 390), this.getCurrentLevel());
        this.addObject(new DefaultBuilding(this.screen, this.control, "/images/garage.png", 100.0, 100.0, "garage"), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 430.0, 150.0, this.control), this.getCurrentLevel());
    }

    public void drawLevelTwo() {
        this.addObject(new DefaultBuilding(this.screen, this.control, "/images/garage.png", 750.0, 100.0, "garage"), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 620, 200), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 640, 230), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 630, 260), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 230.0, 150.0, this.control), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 330.0, 170.0, this.control), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 430.0, 150.0, this.control), this.getCurrentLevel());
    }

    public void drawLevelThree() {
        this.addObject(new Turret(this.car, this.screen, 440.0, 440.0, this.control, true), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 390.0, 150.0, this.control), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 210.0, 120.0, this.control), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 170.0, 320.0, this.control), this.getCurrentLevel());
        this.addObject(new Turret(this.car, this.screen, 220.0, 70.0, this.control, true), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 635, 230), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 620, 260), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 630, 290), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 620, 320), this.getCurrentLevel());
        this.addObject(new Barrel(this.screen, this.control, 640, 350), this.getCurrentLevel());
        this.addObject(new DefaultBuilding(this.screen, this.control, "/images/garage.png", 80.0, 100.0, "garage"), this.getCurrentLevel());
    }

    public void drawLevel(int level) {
        if (level == 1) {
            this.drawLevelOne();
        } else if (level == 2) {
            this.drawLevelTwo();
        } else if (level == 3) {
            this.drawLevelThree();
        }
    }

    public void setLevel(int level) {
        this.currentLevel = level;
    }

    public void addObject(LevelObject obj, int level) {
        LinkedList list = this.getList(this.getCurrentLevel());
        list.add(obj);
    }

    public LinkedList getList(int level) {
        LinkedList list = new LinkedList();
        if (level == 1) {
            list = this.levelOne;
        } else if (level == 2) {
            list = this.levelTwo;
        } else if (level == 3) {
            list = this.levelThree;
        } else {
            return null;
        }
        return list;
    }
}

