/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BlockSystem;
import control.ButtonBuilder;
import control.Car;
import control.GarageButton;
import control.Screen;
import control.Sprite;
import control.TextPaintable;
import java.awt.Font;
import java.awt.Point;

public class GarageUpgrade
implements ButtonBuilder {
    Screen screen;
    Sprite sprite;
    GarageButton healthButton;
    GarageButton ammoButton;
    GarageButton speedButton;
    GarageButton livesButton;
    GarageButton buyButton;
    GarageButton exitButton;
    Point point;
    TextPaintable coinsText;
    TextPaintable descriptionText;
    TextPaintable priceText;
    TextPaintable descriptionText2;
    String selected = "health";
    int selectedPrice;
    int cPrice = 0;
    int cCoins = 0;
    String cDescription = "";
    String cDescription2 = "";
    Car car;

    public GarageUpgrade(Screen window, BlockSystem blocksys, Car c) {
        this.screen = window;
        this.car = c;
        this.screen.setPaused(true);
        this.sprite = this.screen.newSprite("/images/gui_upgrades.png");
        this.sprite.setPosition(this.screen.getWidth() / 2, this.screen.getHeight() / 2);
        this.point = this.getMenuPosition();
        this.healthButton = new GarageButton(this.screen, this.point.getX() + 57.0, this.point.getY() + 74.0, "/images/buttons/button_1.png", "/images/buttons/button_1_selected.png", this, "health");
        this.ammoButton = new GarageButton(this.screen, this.point.getX() + 105.0, this.point.getY() + 74.0, "/images/buttons/button_2.png", "/images/buttons/button_2_selected.png", this, "ammo");
        this.speedButton = new GarageButton(this.screen, this.point.getX() + 155.0, this.point.getY() + 74.0, "/images/buttons/button_3.png", "/images/buttons/button_3_selected.png", this, "speed");
        this.livesButton = new GarageButton(this.screen, this.point.getX() + 204.0, this.point.getY() + 74.0, "/images/buttons/button_4.png", "/images/buttons/button_4_selected.png", this, "lives");
        this.buyButton = new GarageButton(this.screen, this.point.getX() + 80.0, this.point.getY() + 200.0, "/images/buttons/button_buy.png", "/images/buttons/button_buy_selected.png", this, "buy");
        this.exitButton = new GarageButton(this.screen, this.point.getX() + 273.0, this.point.getY() + 4.0, "/images/buttons/button_exit.png", "/images/buttons/button_exit_selected.png", this, "exit");
        this.coinsText = new TextPaintable(this.screen);
        this.descriptionText = new TextPaintable(this.screen);
        this.priceText = new TextPaintable(this.screen);
        this.descriptionText2 = new TextPaintable(this.screen);
        Font font = null;
        font = Font.decode("sans-14");
        this.coinsText.setFont(font);
        this.descriptionText.setFont(font);
        this.priceText.setFont(font);
        this.descriptionText2.setFont(font);
        this.coinsText.setX(this.point.getX() + 40.0);
        this.coinsText.setY(this.point.getY() + 270.0);
        this.descriptionText.setX(this.point.getX() + 40.0);
        this.descriptionText.setY(this.point.getY() + 160.0);
        this.priceText.setX(this.point.getX() + 40.0);
        this.priceText.setY(this.point.getY() + 140.0);
        this.descriptionText2.setX(this.point.getX() + 40.0);
        this.descriptionText2.setY(this.point.getY() + 180.0);
        this.buttonDown("health");
        this.cPrice = 200;
        Runnable run = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GarageUpgrade.this.callFunctions();
                }
            }
        };
        new Thread(run).start();
    }

    public void callFunctions() {
        this.updateText();
    }

    public void updateText() {
        this.cCoins = this.screen.getCoins();
        this.coinsText.setText("You have " + this.cCoins + " coins.");
        this.priceText.setText("Price: " + this.cPrice + " coins");
        this.descriptionText.setText(this.cDescription);
        this.descriptionText2.setText(this.cDescription2);
    }

    public Point getMenuPosition() {
        Point p = new Point();
        p.setLocation(this.screen.getWidth() / 2 - 150, this.screen.getHeight() / 2 - 150);
        return p;
    }

    public void buttonDown(String c) {
        if (c.equals("health")) {
            this.cDescription = "You can upgrade your health by";
            this.cDescription2 = "buying this health upgrade.";
            this.cPrice = 200;
            this.selected = "health";
            this.selectedPrice = 200;
        }
        if (c.equals("ammo")) {
            this.cDescription = "You can upgrade your ammo by";
            this.cDescription2 = "buying this ammo upgrade.";
            this.cPrice = 200;
            this.selected = "ammo";
            this.selectedPrice = 200;
        }
        if (c.equals("lives")) {
            this.cDescription = "You can add one life by buying";
            this.cDescription2 = "this extra life.";
            this.cPrice = 100;
            this.selected = "lives";
            this.selectedPrice = 100;
        }
        if (c.equals("speed")) {
            this.cDescription = "You can upgrade your speed by";
            this.cDescription2 = "buying this speed upgrade.";
            this.cPrice = 300;
            this.selected = "speed";
            this.selectedPrice = 300;
        }
        if (c.equals("exit")) {
            Runnable run = new Runnable(){

                public void run() {
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.healthButton.getSprite());
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.ammoButton.getSprite());
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.speedButton.getSprite());
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.livesButton.getSprite());
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.exitButton.getSprite());
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.buyButton.getSprite());
                    GarageUpgrade.this.screen.destroySprite(GarageUpgrade.this.sprite);
                    GarageUpgrade.this.coinsText.hide();
                    GarageUpgrade.this.priceText.hide();
                    GarageUpgrade.this.descriptionText.hide();
                    GarageUpgrade.this.descriptionText2.hide();
                    GarageUpgrade.this.priceText.hide();
                    GarageUpgrade.this.car.exitGarage();
                }
            };
            new Thread(run).start();
        }
        if (c.equals("buy") && this.screen.getCoins() >= this.selectedPrice) {
            this.screen.setCoins(this.screen.getCoins() - this.selectedPrice);
            Car car = this.screen.getCar();
            if (this.selected.equals("health")) {
                car.setMaxHP(car.getMaxHP() + 100.0);
            } else if (this.selected.equals("ammo")) {
                car.setMaxAmmo(car.getMaxAmmo() + 100);
            } else if (this.selected.equals("lives")) {
                car.setLives(car.getLives() + 1);
            } else if (this.selected.equals("speed")) {
                car.setSpeed(car.getSpeed() + 5.0);
            }
        }
    }
}

