/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.ButtonBuilder;
import control.Screen;
import control.Sprite;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class GarageButton {
    double x;
    double y;
    Screen screen;
    Sprite sprite;
    String image;
    String dragimage;
    String comment;
    ButtonBuilder g;
    boolean stopped = false;

    public GarageButton(Screen window, double dx, double dy, String img, String dragimg, ButtonBuilder n, String com) {
        this.x = dx;
        this.y = dy;
        this.g = n;
        this.comment = com;
        this.image = img;
        this.dragimage = dragimg;
        this.screen = window;
        this.sprite = this.screen.newSprite(img);
        this.sprite.setAnchorPosition(0.0, 0.0);
        this.sprite.setPosition(this.x, this.y);
        this.screen.addMouseInputAdapter(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (GarageButton.this.sprite.overlaps((int)e.getPoint().getX(), (int)e.getPoint().getY())) {
                    GarageButton.this.g.buttonDown(GarageButton.this.comment);
                }
            }
        });
        Runnable run = new Runnable(){

            public void run() {
                while (!GarageButton.this.stopped) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GarageButton.this.checkOver();
                }
            }
        };
        new Thread(run).start();
    }

    public void checkOver() {
        if (this.sprite.overlaps((int)this.screen.getRTMouseX(), (int)this.screen.getRTMouseY())) {
            this.sprite.setImage(this.dragimage);
        } else {
            this.sprite.setImage(this.image);
        }
    }

    public void destroyButton() {
        this.stopped = true;
        this.screen.destroySprite(this.sprite);
    }

    public Sprite getSprite() {
        return this.sprite;
    }
}

