/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.MusicalInstrument;
import control.Screen;
import java.applet.Applet;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class Chess {
    private static final String VERSION = "20070610.1";
    private static long lastFrameTime = 0L;

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static void waitForNextFrame(double framesPerSecond) {
        long time = System.currentTimeMillis();
        long waited = 0L;
        if (lastFrameTime != 0L) {
            int delta = (int)(1000.0 / framesPerSecond);
            while (time < lastFrameTime + (long)delta) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                time = System.currentTimeMillis();
            }
        }
        lastFrameTime = time;
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readString(String prompt) {
        JOptionPane j = new JOptionPane();
        String result = JOptionPane.showInputDialog(null, prompt, "Input Dialog", -1);
        if (result == null) {
            throw new RuntimeException("Cancel was pressed.");
        }
        return result;
    }

    public static String readString() {
        return Chess.readString("Please enter a string: ");
    }

    public static int readInt(String prompt) {
        boolean notGotAnswer = true;
        int answer = -9999;
        while (notGotAnswer) {
            String result = Chess.readString(prompt);
            try {
                answer = Integer.parseInt(result);
                notGotAnswer = false;
            }
            catch (NumberFormatException e) {
                Chess.report("java couldn't read the number, just digits please");
            }
        }
        return answer;
    }

    public static int readInt() {
        return Chess.readInt("Please enter a number: ");
    }

    public static boolean readBoolean(String prompt) {
        new JOptionPane();
        int i = JOptionPane.showConfirmDialog(null, prompt, "Input Dialog", 0);
        return i == 0;
    }

    public static String readYesNo(String prompt) {
        new JOptionPane();
        int i = JOptionPane.showConfirmDialog(null, prompt, "Input Dialog", 0);
        return i == 0 ? "yes" : "no";
    }

    public static void report(String message) {
        new JOptionPane();
        JOptionPane.showMessageDialog(null, message, "Output Dialog", -1);
    }

    public static void report(int i) {
        Chess.report("" + i);
    }

    public static void report(double f) {
        Chess.report("" + f);
    }

    public static double getCurrentTimeSeconds() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static int m(int max) {
        return (int)(Math.random() * (double)max);
    }

    public static double getRan(double min, double max) {
        double dif = max - min;
        double ran = Math.random() * dif;
        return min + ran;
    }

    public static Screen newScreen(JApplet applet) {
        Screen result = new Screen(applet.getWidth(), applet.getHeight(), applet);
        return result;
    }

    public static Screen newScreen() {
        return new Screen(400, 300, null);
    }

    public static Screen newScreen(int width, int height) {
        return new Screen(width, height, null);
    }

    public static MusicalInstrument newMusicalInstrument() {
        return new MusicalInstrument();
    }

    public static void playSound(String filename) {
        URL ff = Chess.findResource(filename);
        if (ff == null) {
            throw new RuntimeException("unable to find file " + filename);
        }
        Applet.newAudioClip(ff).play();
    }

    static final URL findResource(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        URL ff = Chess.class.getResource(resource);
        return ff;
    }
}

