/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BlockSystem;
import control.Chess;
import control.GarageUpgrade;
import control.Hurtable;
import control.Screen;
import control.Sprite;
import control.TextPaintable;

public class Car
implements Hurtable {
    Sprite sprite;
    Sprite gSprite;
    Screen screen;
    double angle = 0.0;
    BlockSystem control;
    private double hp;
    private double maxhp = 100.0;
    private double speed = 20.0;
    private int lives = 3;
    private int ammo;
    private int maxAmmo;

    public Car(Screen window, BlockSystem blocksys) {
        this.control = blocksys;
        this.hp = 100.0;
        this.screen = window;
        this.screen.setCar(this);
        this.sprite = this.screen.newSprite("/images/car_1.png");
        this.returnHome();
        this.sprite.setComment("car");
        this.sprite.setObj(this);
        this.control.addBlocker(this.sprite);
    }

    public int getX() {
        return this.sprite.getPositionX();
    }

    public int getY() {
        return this.sprite.getPositionY();
    }

    public void hitByBullet(double damage) {
        this.hp -= damage;
        if (this.hp < 0.0) {
            this.hp = 0.0;
            this.killCar();
        }
    }

    public void youLose() {
        for (Object a : this.screen.getAllSprites()) {
            this.screen.removeSprite((Sprite)a);
        }
        for (Object i : this.screen.getAllPaintables()) {
            TextPaintable textPaintable = (TextPaintable)i;
        }
        this.screen.clear();
        this.screen.setGameOver(true);
    }

    public void killCar() {
        this.setLives(this.getLives() - 1);
        this.sprite.setImage("images/explosion.gif");
        Chess.sleep(150);
        this.sprite.hide();
        if (this.getLives() > -1) {
            this.returnHome();
            Chess.sleep(2000);
            this.sprite.reveal();
            this.sprite.setImage("images/car_1.png");
            this.setHP(this.getMaxHP());
        } else {
            this.youLose();
        }
    }

    public double getRadians() {
        return this.sprite.getRadians();
    }

    public boolean turnObj(double turn) {
        if (this.getHP() == 0.0) {
            return false;
        }
        this.angle += turn;
        this.sprite.setRadians(this.sprite.getRadians() + turn);
        return false;
    }

    public void returnHome() {
        this.sprite.setPosition(730, 330);
    }

    public double getDX(int forward) {
        return (double)this.sprite.getPositionX() - Math.sin(this.angle) * (double)forward;
    }

    public double getDY(int forward) {
        return (double)this.sprite.getPositionY() + Math.cos(this.angle) * (double)forward;
    }

    public double getPX(double pos, int forward) {
        return pos - Math.sin(this.angle) * (double)forward;
    }

    public double getPY(double pos, int forward) {
        return pos + Math.cos(this.angle) * (double)forward;
    }

    public void setPosition(double dx, double dy) {
        this.sprite.setPosition(dx, dy);
    }

    public void exitGarage() {
        this.gSprite.setImage("/images/garage_carexit.gif");
        Chess.sleep(2860);
        this.screen.setPaused(false);
        this.gSprite.setImage("/images/garage.png");
        this.sprite.reveal();
    }

    public boolean canMove(double dx, double dy) {
        if (this.control.isBlocked(this.getPX(dx, 50), this.getPY(dy, 50), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 20), this.getPY(dy, 20), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 10), this.getPY(dy, 10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, -50), this.getPY(dy, -50), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, -20), this.getPY(dy, -20), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, -10), this.getPY(dy, -10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, -10), this.getPY(dy, -5), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, -5), this.getPY(dy, -10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 10), this.getPY(dy, 5), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5), this.getPY(dy, 10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) - 30.0, this.getPY(dy, 10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) + 30.0, this.getPY(dy, 10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) - 30.0, this.getPY(dy, 10), "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) - 30.0, this.getPY(dy, 10) - 30.0, "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) - 30.0, this.getPY(dy, 10) + 30.0, "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) + 30.0, this.getPY(dy, 10) - 30.0, "car")) {
            return false;
        }
        if (this.control.isBlocked(this.getPX(dx, 5) + 30.0, this.getPY(dy, 10) + 30.0, "car")) {
            return false;
        }
        return !this.control.isBlocked(this.getX(), this.getY(), "car");
    }

    public boolean moveObj(double forward) {
        double dx = this.getDX((int)forward);
        double dy = this.getDY((int)forward);
        if (this.getHP() == 0.0) {
            return false;
        }
        if (!this.canMove(this.sprite.getPositionX(), this.sprite.getPositionY())) {
            // empty if block
        }
        if (!this.canMove(dx, dy)) {
            // empty if block
        }
        if (this.canMove(dx, this.getY()) && dx > 40.0 && dx < (double)(this.screen.getWidth() - 40)) {
            this.sprite.setPosition(dx, (double)this.getY());
        }
        if (this.canMove(this.getX(), dy) && dy > 40.0 && dy < (double)(this.screen.getHeight() - 160)) {
            this.sprite.setPosition((double)this.getX(), dy);
        }
        if (this.control.getBlocker(this.getDX(60), this.getDY(60), "garage") != null) {
            this.screen.setPaused(true);
            Sprite sp = this.control.getBlocker(this.getDX(60), this.getDY(60), "garage");
            this.sprite.hide();
            sp.setImage("/images/garage_carenter.gif");
            this.gSprite = sp;
            boolean frameCount = false;
            Chess.sleep(2860);
            sp.setImage("/images/garage.png");
            new GarageUpgrade(this.screen, this.control, this);
        }
        if (this.control.spriteBlocked(this.sprite)) {
            // empty if block
        }
        if (!(dx > 40.0) || dx < (double)(this.screen.getWidth() - 40)) {
            // empty if block
        }
        if (!(dy > 40.0) || dy < (double)(this.screen.getHeight() - 190)) {
            // empty if block
        }
        return false;
    }

    public double getHP() {
        return this.hp;
    }

    public void setHP(double h) {
        this.hp = h;
    }

    public double getMaxHP() {
        return this.maxhp;
    }

    public void setMaxHP(double maxh) {
        this.maxhp = maxh;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public int getLives() {
        return this.lives;
    }

    public void setLives(int lives) {
        this.lives = lives;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public void setAmmo(int ammo) {
        this.ammo = ammo;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public void setMaxAmmo(int maxAmmo) {
        this.maxAmmo = maxAmmo;
    }
}

