/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BlockSystem;
import control.Chess;
import control.Screen;
import control.Sprite;

public class Bullet {
    Screen screen;
    Sprite sprite;
    String type;
    double angle;
    double x;
    double y;
    boolean move = false;
    boolean stopped = false;
    Thread thread;
    BlockSystem control;
    String j;

    public Bullet(double angl, double dx, double dy, Screen window, BlockSystem blocksys, String exclude, String i) {
        this.screen = window;
        this.angle = angl;
        this.x = dx;
        this.y = dy;
        this.j = i;
        this.type = exclude;
        this.sprite = this.screen.newSprite("/images/bullet.png");
        this.sprite.setPosition(dx, dy);
        this.sprite.setRadians(this.angle);
        this.sprite.setComment("bullet");
        this.control = blocksys;
        Chess.playSound("/sound/bullet.wav");
        Runnable run = new Runnable(){

            public void run() {
                while (!Bullet.this.stopped) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Bullet.this.moveBullet();
                }
            }
        };
        this.thread = new Thread(run);
        this.thread.start();
    }

    public Bullet getBullet() {
        return this;
    }

    public void moveBullet() {
        this.x -= Math.sin(this.angle) * 20.0;
        this.y += Math.cos(this.angle) * 20.0;
        this.sprite.setPosition(this.x, this.y);
        if (this.screen.isGameOver()) {
            this.stopped = true;
            this.screen.destroySprite(this.sprite);
        }
        if (this.control.isBlocked(this.x, this.y, this.type)) {
            Sprite sp = this.control.getBlocker(this.x, this.y, this.j);
            if (sp != null) {
                sp.getObj().hitByBullet(5.0);
            }
            this.stopped = true;
            this.screen.destroySprite(this.sprite);
        }
        if (this.x > (double)this.screen.getWidth() || this.x < 0.0 || this.y > (double)this.screen.getHeight() || this.y < 0.0) {
            this.stopped = true;
            this.screen.destroySprite(this.sprite);
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

