/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Screen;
import control.Sprite;
import java.awt.geom.Area;
import java.util.LinkedList;

public class BlockSystem {
    Screen screen;
    LinkedList<Sprite> ref = new LinkedList();
    Sprite temp;
    int i;

    Area overlap(Sprite s1, Sprite s2) {
        Area a1 = s1.getBounds();
        Area a2 = s2.getBounds();
        Area overlap = new Area(a1);
        overlap.intersect(a2);
        return overlap;
    }

    public BlockSystem(Screen window) {
        this.screen = window;
    }

    public Sprite createBlocker(String image, double x, double y) {
        this.ref.add(this.screen.newSprite(image));
        this.temp = this.ref.getLast();
        this.temp.setAnchorPosition(0.0, 0.0);
        this.temp.setPosition(x, y);
        return this.temp;
    }

    public Sprite createBlocker(String image, double x, double y, String com) {
        this.ref.add(this.screen.newSprite(image));
        this.temp = this.ref.getLast();
        this.temp.setAnchorPosition(0.0, 0.0);
        this.temp.setPosition(x, y);
        this.temp.setComment(com);
        return this.temp;
    }

    public void removeBlocker(Sprite blocker) {
        this.ref.remove(blocker);
    }

    public void addBlocker(Sprite blocker) {
        this.ref.add(blocker);
    }

    public boolean spriteBlocked(Sprite blocker) {
        for (Sprite t : this.ref) {
            if (this.overlap(blocker, t).isEmpty() || t.getComment() == "car") continue;
            return true;
        }
        return false;
    }

    public Sprite getBlocker(double dx, double dy, String type) {
        Sprite sp = type == "null" ? this.screen.getSpriteAt((int)dx, (int)dy) : this.screen.getSpriteAtWithComment((int)dx, (int)dy, type);
        return sp;
    }

    public Sprite getBlocker(double dx, double dy) {
        Sprite sp = this.screen.getSpriteAt((int)dx, (int)dy);
        return sp;
    }

    public boolean isBlocked(double dx, double dy, String exclude) {
        if (this.ref.size() < 0) {
            return false;
        }
        for (Sprite t : this.ref) {
            if (!t.overlaps((int)dx, (int)dy) || t.getComment() == exclude) continue;
            return true;
        }
        return false;
    }
}

