/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.BlockSystem;
import control.Chess;
import control.Hurtable;
import control.LevelObject;
import control.Screen;
import control.Sprite;

public class Barrel
implements Hurtable,
LevelObject {
    Screen screen;
    Sprite sprite;
    BlockSystem control;
    boolean stopped = false;
    int coins = 100;
    double hp = 50.0;

    public Barrel(Screen window, BlockSystem ctrl, int dx, int dy) {
        this.control = ctrl;
        this.screen = window;
        this.sprite = this.screen.newSprite("/images/barrel.png", dx, dy);
        this.sprite.setComment("hittable");
        this.sprite.setObj(this);
        this.control.addBlocker(this.sprite);
    }

    public boolean canDie() {
        return false;
    }

    public void killSelf() {
        this.screen.removeSprite(this.sprite);
        this.control.removeBlocker(this.sprite);
        this.stopped = true;
    }

    public boolean isDead() {
        return true;
    }

    public void hitByBullet(double damage) {
        this.hp -= damage;
        if (this.hp < 0.0) {
            this.hp = 0.0;
        }
        if (this.hp == 0.0 && !this.stopped) {
            this.stopped = true;
            this.sprite.setImage("/images/explosion.gif");
            Chess.sleep(200);
            this.control.removeBlocker(this.sprite);
            this.screen.destroySprite(this.sprite);
            this.screen.setCoins(this.screen.getCoins() + this.coins);
            this.sprite = null;
        }
    }
}

