/*
 * Decompiled with CFR 0.152.
 */
import control.BlockSystem;
import control.Bullet;
import control.Car;
import control.Chess;
import control.LevelManager;
import control.LinePaintable;
import control.RunnableApplet;
import control.Screen;
import control.TextPaintable;
import control.Turret;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.LinkedList;
import javax.swing.JFrame;

public class FinalCar
extends RunnableApplet {
    Screen window;
    BlockSystem control;
    Car carOne;
    Turret turret;
    TextPaintable lives;
    TextPaintable speed;
    TextPaintable health;
    TextPaintable ammo;
    LevelManager manager;
    LinkedList bullets;
    LinePaintable laser;
    double angle;
    int sleep;

    public void init() {
        this.window = Chess.newScreen(this);
        this.control = new BlockSystem(this.window);
        Font font = null;
        font = Font.decode("sans-20");
        this.carOne = new Car(this.window, this.control);
        this.control.createBlocker("/images/gui.png", 0.0, 540.0);
        this.laser = new LinePaintable(this.window, Color.GREEN, 0.0, 0.0, 0.0, 0.0);
        this.manager = new LevelManager(this.window, this.control, this.carOne);
        this.window.setCoins(500);
        this.health = new TextPaintable(this.window);
        this.health.setX(56.0);
        this.health.setY(610.0);
        this.ammo = new TextPaintable(this.window);
        this.ammo.setX(236.0);
        this.ammo.setY(610.0);
        this.lives = new TextPaintable(this.window);
        this.lives.setX(745.0);
        this.lives.setY(610.0);
        this.speed = new TextPaintable(this.window);
        this.speed.setX(555.0);
        this.speed.setY(610.0);
        this.health.setFont(font);
        this.ammo.setFont(font);
        this.lives.setFont(font);
        this.speed.setFont(font);
        this.carOne.setAmmo(300);
        this.carOne.setMaxAmmo(300);
        this.sleep = 0;
    }

    public void run() {
        while (true) {
            this.health.setText("" + (int)this.carOne.getHP() + "/" + (int)this.carOne.getMaxHP());
            this.ammo.setText("" + this.carOne.getAmmo() + "/" + this.carOne.getMaxAmmo());
            this.speed.setText("" + (int)this.carOne.getSpeed());
            this.lives.setText("" + this.carOne.getLives());
            ++this.sleep;
            if (this.window.keyDown(82) && !this.window.isPaused()) {
                this.carOne.returnHome();
            }
            if (this.window.keyDown(37) && !this.window.isPaused()) {
                this.carOne.turnObj(-0.1);
            }
            if (this.window.keyDown(39) && !this.window.isPaused()) {
                this.carOne.turnObj(0.1);
            }
            if (this.window.keyDown(38) && !this.window.isPaused()) {
                this.carOne.moveObj(this.carOne.getSpeed());
            }
            if (this.window.keyDown(40) && !this.window.isPaused()) {
                this.carOne.moveObj(-5.0);
            }
            if (this.window.isMouseDown() && !this.window.isPaused() && this.sleep > 3 && this.carOne.getAmmo() > 0) {
                this.angle = Math.atan2(this.carOne.getDX(40) - this.window.getRTMouseX(), this.window.getRTMouseY() - this.carOne.getDY(40));
                Bullet b = new Bullet(this.angle, this.carOne.getDX(40), this.carOne.getDY(40), this.window, this.control, "car", "hittable");
                this.sleep = 0;
                this.carOne.setAmmo(this.carOne.getAmmo() - 1);
            }
            Chess.waitForNextFrame(60.0);
        }
    }

    public void showLaser() {
        this.angle = Math.atan2(this.carOne.getDX(40) - this.window.getRTMouseX(), this.window.getRTMouseY() - this.carOne.getDY(40));
        boolean move = false;
        double dx = this.carOne.getDX(40);
        double dy = this.carOne.getDY(40);
        double tempx = dx;
        double tempy = dy;
        double tox = 0.0;
        double toy = 0.0;
        boolean temp = false;
        tempx -= Math.sin(this.angle) * 40.0;
        tempy += Math.cos(this.angle) * 40.0;
        while (!move) {
            if (this.control.isBlocked(tempx -= Math.sin(this.angle) * 1.0, tempy += Math.cos(this.angle) * 1.0, "hittable")) {
                temp = true;
                move = true;
                tox = tempx;
                toy = tempy;
            } else if (this.control.isBlocked(tempx, tempy, "")) {
                temp = false;
                move = true;
                tox = tempx;
                toy = tempy;
            }
            if (!(tempx < 0.0 || tempx > (double)this.window.getWidth() || tempy < 0.0) && !(tempy > (double)this.window.getHeight())) continue;
            temp = false;
            move = true;
            tox = tempx;
            toy = tempy;
        }
        this.laser.repositionLine(this.carOne.getDX(40), this.carOne.getDY(40), tox, toy);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("FinalCar");
        frame.setDefaultCloseOperation(3);
        FinalCar applet = new FinalCar();
        Dimension appletDimension = new Dimension(850, 700);
        applet.setMinimumSize(appletDimension);
        applet.setPreferredSize(appletDimension);
        frame.setContentPane(applet);
        frame.pack();
        frame.setVisible(true);
        ((Applet)applet).init();
        ((Applet)applet).start();
    }
}

