/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Constructor;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsScreenProxy;
import net.minecraft.realms.pluginapi.LoadedRealmsPlugin;
import net.minecraft.realms.pluginapi.RealmsPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsBridge
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private czt previousScreen;

    public void switchToRealms(czt czt2) {
        this.previousScreen = czt2;
        Optional<LoadedRealmsPlugin> optional = this.tryLoadRealms();
        if (optional.isPresent()) {
            Realms.setScreen(optional.get().getMainScreen(this));
        } else {
            this.showMissingRealmsErrorScreen();
        }
    }

    @Nullable
    public RealmsScreenProxy getNotificationScreen(czt czt2) {
        this.previousScreen = czt2;
        return this.tryLoadRealms().map(loadedRealmsPlugin -> loadedRealmsPlugin.getNotificationsScreen(this).getProxy()).orElse(null);
    }

    private Optional<LoadedRealmsPlugin> tryLoadRealms() {
        try {
            Class<?> clazz = Class.forName("com.mojang.realmsclient.plugin.RealmsPluginImpl");
            Constructor<?> \u26032 = clazz.getDeclaredConstructor(new Class[0]);
            \u26032.setAccessible(true);
            Object \u26033 = \u26032.newInstance(new Object[0]);
            RealmsPlugin \u26034 = (RealmsPlugin)\u26033;
            Either<LoadedRealmsPlugin, String> \u26035 = \u26034.tryLoad(Realms.getMinecraftVersionString());
            Optional \u26036 = \u26035.right();
            if (\u26036.isPresent()) {
                LOGGER.error("Failed to load Realms module: {}", \u26036.get());
                return Optional.empty();
            }
            return \u26035.left();
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Realms module missing");
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load Realms module", (Throwable)exception);
        }
        return Optional.empty();
    }

    @Override
    public void init() {
        cvk.u().a(this.previousScreen);
    }

    private void showMissingRealmsErrorScreen() {
        cvk.u().a(new cyq(() -> cvk.u().a(this.previousScreen), new jv(""), new jw(o.a().isStable() ? "realms.missing.module.error.text" : "realms.missing.snapshot.error.text", new Object[0])));
    }
}

