/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends agj<rh>
implements ahg,
cc,
AutoCloseable,
Runnable {
    private static final Logger i = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    public static final bhe c = new bhe("North Carolina".hashCode(), bgx.b, true, false, bhh.b).a();
    private final cnw j;
    private final ahf k = new ahf("server", this, p.b());
    private final File l;
    private final List<Runnable> m = Lists.newArrayList();
    private final afy n = new afy(this::ai);
    private final vw o;
    protected final vp d;
    private final qc p = new qc();
    private final Random q = new Random();
    private final DataFixer r;
    private String s;
    private int t = -1;
    private final Map<bxw, vf> u = Maps.newIdentityHashMap();
    private xp v;
    private volatile boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    @Nullable
    private String F;
    private int G;
    private int H;
    public final long[] f = new long[100];
    protected final Map<bxw, long[]> g = Maps.newIdentityHashMap();
    @Nullable
    private KeyPair I;
    @Nullable
    private String J;
    private final String K;
    @Nullable
    private String L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private volatile boolean Q;
    private long R;
    @Nullable
    private jm S;
    private boolean T;
    private boolean U;
    @Nullable
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final xl Y;
    private long Z;
    protected final Thread h = p.a(new Thread((Runnable)this, "Server thread"), (T thread2) -> thread2.setUncaughtExceptionHandler((thread, throwable) -> i.error((Object)throwable)));
    private long aa = p.b();
    private boolean ab;
    private final xb ac = new xh(wh.b, this.h);
    private final ws<wv> ad = new ws<wv>(wv::new);
    @Nullable
    private wq ae;
    private final ce af;
    private final bed ag = new bed();
    private final zc ah = new zc();
    private final rg ai = new rg(this);
    private final rj aj = new rj(this);
    private final coj ak = new coj();
    private final rd al = new rd();
    private final re am = new re(this);
    private final zk an = new zk();
    private boolean ao;
    private boolean ap;
    private boolean aq;
    private float ar;
    private final Executor as;
    @Nullable
    private String at;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, ce ce2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, xl xl2, vp vp2, String string) {
        super("Server");
        this.e = proxy;
        this.af = ce2;
        this.V = yggdrasilAuthenticationService;
        this.W = minecraftSessionService;
        this.X = gameProfileRepository;
        this.Y = xl2;
        this.l = file;
        this.o = new vw(this);
        this.d = vp2;
        this.j = new cnw(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.r = dataFixer;
        this.ac.a(this.ah);
        this.ac.a(this.ag);
        this.ac.a(this.ak);
        this.ac.a(this.am);
        this.ac.a(this.al);
        this.as = p.e();
        this.K = string;
    }

    @Override
    private void a(cns cns2) {
        csp csp2 = cns2.a(csp::new, "scoreboard");
        csp2.a(this.aL());
        this.aL().a(new cni(csp2));
    }

    protected abstract boolean d() throws IOException;

    @Override
    protected void a(String string) {
        if (this.N().a(string)) {
            i.info("Converting map!");
            this.b(new jw("menu.convertingLevel", new Object[0]));
            this.N().a(string, new zs(){
                private long b = p.b();

                @Override
                public void a(jm jm2) {
                }

                @Override
                public void b(jm jm2) {
                }

                @Override
                public void a(int n2) {
                    if (p.b() - this.b >= 1000L) {
                        this.b = p.b();
                        i.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(jm jm2) {
                }
            });
        }
        if (this.ap) {
            i.info("Forcing world upgrade!");
            cnt cnt2 = this.N().b(this.J());
            if (cnt2 != null) {
                agm agm2 = new agm(this.J(), this.N(), cnt2, this.aq);
                jm \u26032 = null;
                while (!agm2.b()) {
                    jm jm2 = agm2.g();
                    if (\u26032 != jm2) {
                        \u26032 = jm2;
                        i.info(agm2.g().getString());
                    }
                    if ((\u2603 = agm2.d()) > 0) {
                        int n2 = agm2.e() + agm2.f();
                        i.info("{}% completed ({} / {} chunks)...", (Object)zr.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
                    }
                    if (this.ac()) {
                        agm2.a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void b(jm jm2) {
        this.S = jm2;
    }

    protected void a(String string, String string2, long l22, bhh bhh2, JsonElement jsonElement) {
        bhe \u26033;
        this.a(string);
        this.b(new jw("menu.loadingLevel", new Object[0]));
        cnu cnu2 = this.N().a(string, this);
        this.a(this.J(), cnu2);
        cnt \u26032 = cnu2.c();
        if (\u26032 == null) {
            if (this.M()) {
                \u26033 = c;
            } else {
                long l22;
                \u26033 = new bhe(l22, this.g(), this.f(), this.i(), bhh2);
                \u26033.a(jsonElement);
                if (this.N) {
                    \u26033.a();
                }
            }
            \u26032 = new cnt(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new bhe(\u26032);
        }
        this.a(cnu2.a(), \u26032);
        vo vo2 = this.d.create(11);
        this.a(cnu2, \u26032, \u26033, vo2);
        this.a(this.h(), true);
        this.a(vo2);
    }

    protected void a(cnu cnu2, cnt cnt22, bhe bhe2, vo vo2) {
        vf vf2;
        if (this.M()) {
            cnt22.a(c);
        }
        vf vf3 = new vf(this, this.as, cnu2, cnt22, bxw.a, this.n, vo2);
        this.u.put(bxw.a, vf3);
        this.a(vf3.x());
        vf3.q_().b(cnt22);
        vf2 = this.a(bxw.a);
        if (!cnt22.v()) {
            cnt cnt22;
            try {
                vf2.a(bhe2);
                if (cnt22.t() == bhh.h) {
                    this.a(cnt22);
                }
                cnt22.d(true);
            }
            catch (Throwable throwable) {
                d d2 = d.a(throwable, "Exception initializing level");
                try {
                    vf2.a(d2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new m(d2);
            }
            cnt22.d(true);
        }
        this.ad().a(vf2);
        if (cnt22.Q() != null) {
            this.aO().a(cnt22.Q());
        }
        for (bxw bxw2 : bxw.a()) {
            if (bxw2 == bxw.a) continue;
            this.u.put(bxw2, new ux(vf2, this, this.as, cnu2, bxw2, (agc)this.n, vo2));
        }
    }

    @Override
    private void a(cnt cnt2) {
        cnt2.f(false);
        cnt2.c(true);
        cnt2.b(false);
        cnt2.a(false);
        cnt2.g(1000000000);
        cnt2.b(6000L);
        cnt2.a(bgx.e);
        cnt2.g(false);
        cnt2.a(agv.a);
        cnt2.e(true);
        cnt2.w().a("doDaylightCycle", "false", this);
    }

    protected void a(File file, cnt cnt2) {
        this.ad.a(new wu());
        this.ae = new wq(new File(file, "datapacks"));
        this.ad.a(this.ae);
        this.ad.a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : cnt2.P()) {
            wv wv2 = this.ad.a(string);
            if (wv2 != null) {
                arrayList.add(wv2);
                continue;
            }
            i.warn("Missing data pack {}", (Object)string);
        }
        this.ad.a(arrayList);
        this.b(cnt2);
    }

    @Override
    protected void a(vo vo2) {
        this.b(new jw("menu.generatingTerrain", new Object[0]));
        vf vf2 = this.a(bxw.a);
        i.info("Preparing start region for dimension " + bxw.a(vf2.q.p()));
        ev \u26032 = vf2.o_();
        vo2.a(new bgn(\u26032));
        vd \u26033 = vf2.m();
        \u26033.a().a(500);
        this.aa = p.b();
        \u26033.a(vk.a, new bgn(\u26032), 11, zz.a);
        while (\u26033.b() != 441) {
            this.aa += 100L;
            this.o();
        }
        this.aa += 100L;
        this.o();
        for (bxw bxw2 : bxw.a()) {
            bgv bgv2 = this.a(bxw2).x().b(bgv::new, "chunks");
            if (bgv2 == null) continue;
            vf \u26034 = this.a(bxw2);
            LongIterator \u26035 = bgv2.a().iterator();
            while (\u26035.hasNext()) {
                long l2 = \u26035.nextLong();
                bgn \u26036 = new bgn(l2);
                \u26034.m().a(\u26036, true);
            }
        }
        this.aa += 100L;
        this.o();
        vo2.b();
        \u26033.a().a(5);
    }

    protected void a(String string, cnu cnu2) {
        File file = new File(cnu2.a(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                i.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean f();

    public abstract bgx g();

    public abstract agv h();

    public abstract boolean i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (vf vf2 : this.x()) {
            if (!bl2) {
                i.info("Saving chunks for level '{}'/{}", (Object)vf2.p_().j(), (Object)bxw.a(vf2.q.p()));
            }
            try {
                vf2.a(null, bl3, vf2.b && !bl4);
            }
            catch (bhc bhc2) {
                i.warn(bhc2.getMessage());
            }
            bl5 = true;
        }
        vf vf2 = this.a(bxw.a);
        cnt cnt2 = vf2.p_();
        vf2.q_().a(cnt2);
        cnt2.c(this.aO().c());
        vf2.w().a(cnt2, this.ad().r());
        return bl5;
    }

    @Override
    public void close() {
        this.l();
    }

    protected void l() {
        i.info("Stopping server");
        if (this.af() != null) {
            this.af().b();
        }
        if (this.v != null) {
            i.info("Saving players");
            this.v.i();
            this.v.s();
        }
        i.info("Saving worlds");
        for (vf vf2 : this.x()) {
            if (vf2 == null) continue;
            vf2.b = false;
        }
        this.a(false, true, false);
        for (vf vf2 : this.x()) {
            if (vf2 == null) continue;
            try {
                vf2.close();
            }
            catch (IOException iOException) {
                i.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
    }

    public String m() {
        return this.s;
    }

    public void b(String string) {
        this.s = string;
    }

    public boolean h_() {
        return this.w;
    }

    @Override
    public void a(boolean bl2) {
        this.w = false;
        if (bl2) {
            try {
                this.h.join();
            }
            catch (InterruptedException interruptedException) {
                i.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                this.aa = p.b();
                this.p.a(new jv(this.F));
                this.p.a(new qc.c(o.a().getName(), o.a().getProtocolVersion()));
                this.a(this.p);
                while (this.w) {
                    long l2 = p.b() - this.aa;
                    if (l2 > 2000L && this.aa - this.R >= 15000L) {
                        \u2603 = l2 / 50L;
                        i.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.aa += \u2603 * 50L;
                        this.R = this.aa;
                    }
                    this.aa += 50L;
                    if (this.T) {
                        this.T = false;
                        this.n.d().d();
                    }
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::aV);
                    this.n.b("nextTickWait");
                    this.o();
                    this.n.c();
                    this.n.b();
                    this.Q = true;
                }
            } else {
                this.a((d)null);
            }
        }
        catch (Throwable throwable) {
            i.error("Encountered an unexpected exception", throwable);
            d d2 = throwable instanceof m ? this.b(((m)throwable).a()) : this.b(new d("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.s(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (d2.a(\u26032)) {
                i.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                i.error("We were unable to save this crash report to disk.");
            }
            this.a(d2);
        }
        finally {
            try {
                this.x = true;
                this.l();
            }
            catch (Throwable \u26033) {
                i.error("Exception stopping the server", \u26033);
            }
            finally {
                this.t();
            }
        }
    }

    private boolean aV() {
        return this.bg() || p.b() < this.aa;
    }

    protected void o() {
        this.bf();
        this.c(() -> !this.aV());
    }

    protected rh a(Runnable runnable) {
        return new rh(this.y, runnable);
    }

    protected boolean a(rh rh2) {
        return rh2.a() + 3 < this.y || this.aV();
    }

    @Override
    public boolean p() {
        if (super.p()) {
            return true;
        }
        if (this.aV()) {
            for (vf vf2 : this.x()) {
                if (!vf2.m().d()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(qc qc2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.N().b(this.J(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                qc2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                i.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean q() {
        this.ab = this.ab || this.r().isFile();
        return this.ab;
    }

    public File r() {
        return this.N().b(this.J(), "icon.png");
    }

    public File s() {
        return new File(".");
    }

    @Override
    protected void a(d d2) {
    }

    protected void t() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = p.c();
        ++this.y;
        this.b(booleanSupplier);
        if (l2 - this.Z >= 5000000000L) {
            this.Z = l2;
            this.p.a(new qc.a(this.A(), this.z()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.z(), 12)];
            int \u26032 = zr.a(this.q, 0, this.z() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.t().get(\u26032 + i2).dF();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.p.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            i.debug("Autosave started");
            this.n.a("save");
            this.v.i();
            this.a(true, false, false);
            this.n.c();
            i.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.y > 100) {
            this.k.a();
        }
        if (this.y % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = p.c() - l2;
        this.f[this.y % 100] = l3;
        \u2603 = l3;
        this.ar = this.ar * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = p.c();
        this.an.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.aC().e();
        this.n.b("levels");
        for (vf vf2 : this.x()) {
            long l2 = p.c();
            if (vf2.q.p() == bxw.a || this.u()) {
                this.n.a(() -> vf2.p_().j() + " " + fm.x.b(vf2.q.p()));
                if (this.y % 20 == 0) {
                    this.n.a("timeSync");
                    this.v.a(new nb(vf2.R(), vf2.S(), vf2.T().b("doDaylightCycle")), vf2.q.p());
                    this.n.c();
                }
                this.n.a("tick");
                try {
                    vf2.a(booleanSupplier);
                }
                catch (Throwable throwable) {
                    d d2 = d.a(throwable, "Exception ticking world");
                    vf2.a(d2);
                    throw new m(d2);
                }
                this.n.c();
                this.n.c();
            }
            this.g.computeIfAbsent((bxw)vf2.q.p(), (Function<bxw, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, b(bxw ), (Lbxw;)[J)())[this.y % 100] = p.c() - l2;
        }
        this.n.b("connection");
        this.af().c();
        this.n.b("players");
        this.v.d();
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.m.size(); ++i2) {
            this.m.get(i2).run();
        }
        this.n.c();
    }

    public boolean u() {
        return true;
    }

    public void b(Runnable runnable) {
        this.m.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            ui \u260316 = new ui(\u260315);
            \u260316.b();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            qz \u260318 = new qz(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                i.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.a()) {
                i.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            qu.a();
            qu.c();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            xl \u260323 = new xl(\u260322, new File(\u260319, b.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.a().o);
            final ug \u260325 = new ug(new File(\u260319), \u260316, aad.a(), \u260320, \u260321, \u260322, \u260323, vq::new, \u260324);
            \u260325.i((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.a((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.e(optionSet.has((OptionSpec)\u26034));
            \u260325.f(optionSet.has((OptionSpec)\u26035));
            \u260325.b(optionSet.has((OptionSpec)\u26036));
            \u260325.c(optionSet.has((OptionSpec)\u26037));
            \u260325.c((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl2 = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.aY();
            }
            \u260325.v();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.a(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new g(i));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            i.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void c(String string) {
        this.at = string;
    }

    protected void b(boolean bl2) {
        this.ap = bl2;
    }

    protected void c(boolean bl2) {
        this.aq = bl2;
    }

    public void v() {
        this.h.start();
    }

    public boolean w() {
        return !this.h.isAlive();
    }

    public File d(String string) {
        return new File(this.s(), string);
    }

    public void e(String string) {
        i.info(string);
    }

    public void f(String string) {
        i.warn(string);
    }

    public vf a(bxw bxw2) {
        return this.u.get(bxw2);
    }

    public Iterable<vf> x() {
        return this.u.values();
    }

    public String y() {
        return o.a().getName();
    }

    public int z() {
        return this.v.n();
    }

    public int A() {
        return this.v.o();
    }

    public String[] B() {
        return this.v.e();
    }

    public boolean D() {
        return false;
    }

    @Override
    public void g(String string) {
        i.error(string);
    }

    @Override
    public void h(String string) {
        if (this.D()) {
            i.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public d b(d d2) {
        if (this.v != null) {
            d2.g().a("Player Count", () -> this.v.n() + " / " + this.v.o() + "; " + this.v.t());
        }
        d2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (wv wv2 : this.ad.d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(wv2.e());
                if (wv2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.at != null) {
            d2.g().a("Server Id", () -> this.at);
        }
        return d2;
    }

    public boolean E() {
        return this.l != null;
    }

    @Override
    public void a(jm jm2) {
        i.info(jm2.getString());
    }

    public KeyPair F() {
        return this.I;
    }

    public int G() {
        return this.t;
    }

    @Override
    public void a(int n2) {
        this.t = n2;
    }

    public String H() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public boolean I() {
        return this.J != null;
    }

    public String J() {
        return this.K;
    }

    public void j(String string) {
        this.L = string;
    }

    public String K() {
        return this.L;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(agv agv2, boolean bl2) {
        for (vf vf2 : this.x()) {
            cnt cnt2 = vf2.p_();
            if (!bl2 && cnt2.y()) continue;
            if (cnt2.s()) {
                cnt2.a(agv.d);
                vf2.a(true, true);
                continue;
            }
            if (this.I()) {
                cnt2.a(agv2);
                vf2.a(vf2.ac() != agv.a, true);
                continue;
            }
            cnt2.a(agv2);
            vf2.a(this.L(), this.B);
        }
        this.ad().t().forEach(this::a);
    }

    public void d(boolean bl2) {
        for (vf vf2 : this.x()) {
            cnt cnt2 = vf2.p_();
            cnt2.e(bl2);
        }
        this.ad().t().forEach(this::a);
    }

    @Override
    private void a(vg vg2) {
        cnt cnt2 = vg2.s().p_();
        vg2.b.a(new kr(cnt2.x(), cnt2.y()));
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.M;
    }

    public void e(boolean bl2) {
        this.M = bl2;
    }

    public void f(boolean bl2) {
        this.N = bl2;
    }

    public cnw N() {
        return this.j;
    }

    public String O() {
        return this.O;
    }

    public String P() {
        return this.P;
    }

    public void a(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(ahf ahf22) {
        ahf ahf22;
        ahf22.a("whitelist_enabled", false);
        ahf22.a("whitelist_count", 0);
        if (this.v != null) {
            ahf22.a("players_current", this.z());
            ahf22.a("players_max", this.A());
            ahf22.a("players_seen", this.a(bxw.a).w().d().length);
        }
        ahf22.a("uses_auth", this.z);
        ahf22.a("gui_state", this.ah() ? "enabled" : "disabled");
        ahf22.a("run_time", (p.b() - ahf22.g()) / 60L * 1000L);
        ahf22.a("avg_tick_ms", (int)(zr.a(this.f) * 1.0E-6));
        int n2 = 0;
        for (vf vf2 : this.x()) {
            if (vf2 == null) continue;
            cnt cnt2 = vf2.p_();
            ahf22.a("world[" + n2 + "][dimension]", vf2.q.p());
            ahf22.a("world[" + n2 + "][mode]", (Object)cnt2.q());
            ahf22.a("world[" + n2 + "][difficulty]", (Object)vf2.ac());
            ahf22.a("world[" + n2 + "][hardcore]", cnt2.s());
            ahf22.a("world[" + n2 + "][generator_name]", cnt2.t().a());
            ahf22.a("world[" + n2 + "][generator_version]", cnt2.t().e());
            ahf22.a("world[" + n2 + "][height]", this.G);
            ahf22.a("world[" + n2 + "][chunks_loaded]", vf2.m().g());
            ++n2;
        }
        ahf22.a("worlds", n2);
    }

    public abstract boolean R();

    public boolean S() {
        return this.z;
    }

    @Override
    public void g(boolean bl2) {
        this.z = bl2;
    }

    public boolean T() {
        return this.A;
    }

    @Override
    public void h(boolean bl2) {
        this.A = bl2;
    }

    public boolean U() {
        return this.B;
    }

    public void i(boolean bl2) {
        this.B = bl2;
    }

    public boolean V() {
        return this.C;
    }

    public abstract boolean W();

    public void j(boolean bl2) {
        this.C = bl2;
    }

    public boolean X() {
        return this.D;
    }

    public void k(boolean bl2) {
        this.D = bl2;
    }

    public boolean Y() {
        return this.E;
    }

    public void l(boolean bl2) {
        this.E = bl2;
    }

    public abstract boolean Z();

    public String aa() {
        return this.F;
    }

    public void k(String string) {
        this.F = string;
    }

    public int ab() {
        return this.G;
    }

    public void b(int n2) {
        this.G = n2;
    }

    public boolean ac() {
        return this.x;
    }

    public xp ad() {
        return this.v;
    }

    @Override
    public void a(xp xp2) {
        this.v = xp2;
    }

    public abstract boolean ae();

    @Override
    public void a(bgx bgx2) {
        for (vf vf2 : this.x()) {
            vf2.p_().a(bgx2);
        }
    }

    @Nullable
    public vw af() {
        return this.o;
    }

    public boolean ag() {
        return this.Q;
    }

    public boolean ah() {
        return false;
    }

    public abstract boolean a(bgx var1, boolean var2, int var3);

    public int ai() {
        return this.y;
    }

    public void aj() {
        this.T = true;
    }

    public ahf ak() {
        return this.k;
    }

    public int am() {
        return 16;
    }

    public boolean a(bha bha2, ev ev2, avr avr2) {
        return false;
    }

    public void m(boolean bl2) {
        this.U = bl2;
    }

    public boolean an() {
        return this.U;
    }

    public int ap() {
        return this.H;
    }

    public void c(int n2) {
        this.H = n2;
    }

    public MinecraftSessionService aq() {
        return this.W;
    }

    public GameProfileRepository ar() {
        return this.X;
    }

    public xl as() {
        return this.Y;
    }

    public qc at() {
        return this.p;
    }

    public void au() {
        this.Z = 0L;
    }

    public int av() {
        return 29999984;
    }

    @Override
    public boolean aw() {
        return super.aw() && !this.ac();
    }

    @Override
    public Thread ax() {
        return this.h;
    }

    public int ay() {
        return 256;
    }

    public long az() {
        return this.aa;
    }

    public DataFixer aA() {
        return this.r;
    }

    public int a(@Nullable vf vf2) {
        if (vf2 != null) {
            return vf2.T().c("spawnRadius");
        }
        return 10;
    }

    public rd aB() {
        return this.al;
    }

    public re aC() {
        return this.am;
    }

    public void aD() {
        if (!this.bc()) {
            this.execute(this::aD);
            return;
        }
        this.ad().i();
        this.ad.a();
        this.b(this.a(bxw.a).p_());
        this.ad().u();
    }

    private void b(cnt cnt2) {
        ArrayList arrayList = Lists.newArrayList(this.ad.d());
        for (wv wv3 : this.ad.b()) {
            if (cnt2.O().contains(wv3.e()) || arrayList.contains(wv3)) continue;
            i.info("Found new data pack {}, loading it automatically", (Object)wv3.e());
            wv3.h().a(arrayList, wv3, (T wv2) -> wv2, false);
        }
        this.ad.a(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.ad.d().forEach(wv2 -> arrayList2.add(wv2.d()));
        CompletableFuture<zz> completableFuture = this.ac.a(this.as, (Executor)this, arrayList2, CompletableFuture.completedFuture(zz.a));
        this.c(completableFuture::isDone);
        cnt2.P().clear();
        cnt2.O().clear();
        this.ad.d().forEach(wv2 -> cnt2.P().add(wv2.e()));
        this.ad.b().forEach(wv2 -> {
            if (!this.ad.d().contains(wv2)) {
                cnt2.O().add(wv2.e());
            }
        });
    }

    @Override
    public void a(cd cd2) {
        if (!this.aP()) {
            return;
        }
        xp xp2 = cd2.j().ad();
        xw \u26032 = xp2.j();
        if (!\u26032.b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(xp2.t());
        for (vg vg2 : \u26033) {
            if (\u26032.a(vg2.dF())) continue;
            vg2.b.b(new jw("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public xb aE() {
        return this.ac;
    }

    public ws<wv> aF() {
        return this.ad;
    }

    public ce aH() {
        return this.af;
    }

    public cd aI() {
        return new cd(this, this.a(bxw.a) == null ? cro.a : new cro(this.a(bxw.a).o_()), crn.a, this.a(bxw.a), 4, "Server", new jv("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public bed aJ() {
        return this.ag;
    }

    public zc aK() {
        return this.ah;
    }

    public rg aL() {
        return this.ai;
    }

    public coj aM() {
        return this.ak;
    }

    public bgw aN() {
        return this.a(bxw.a).T();
    }

    public rj aO() {
        return this.aj;
    }

    public boolean aP() {
        return this.ao;
    }

    public void n(boolean bl2) {
        this.ao = bl2;
    }

    public float aQ() {
        return this.ar;
    }

    public int a(GameProfile gameProfile) {
        if (this.ad().h(gameProfile)) {
            xr xr2 = (xr)this.ad().l().b(gameProfile);
            if (xr2 != null) {
                return xr2.a();
            }
            if (this.b(gameProfile)) {
                return 4;
            }
            if (this.I()) {
                return this.ad().v() ? 4 : 0;
            }
            return this.j();
        }
        return 0;
    }

    public zk aR() {
        return this.an;
    }

    public afy aS() {
        return this.n;
    }

    public Executor aT() {
        return this.as;
    }

    public abstract boolean b(GameProfile var1);

    @Override
    public /* synthetic */ boolean c(Runnable runnable) {
        return this.a((rh)runnable);
    }

    @Override
    public /* synthetic */ Runnable d(Runnable runnable) {
        return this.a(runnable);
    }

    private static /* synthetic */ long[] b(bxw bxw2) {
        return new long[100];
    }
}

