/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;

public class TextureUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MIN_MIPMAP_LEVEL = 0;
    private static final int DEFAULT_IMAGE_BUFFER_SIZE = 8192;

    public static int generateTextureId() {
        return GlStateManager.genTexture();
    }

    public static void releaseTextureId(int n2) {
        GlStateManager.deleteTexture(n2);
    }

    public static void prepareImage(int n2, int n3, int n4) {
        TextureUtil.prepareImage(ctp.b.a, n2, 0, n3, n4);
    }

    public static void prepareImage(ctp.b b2, int n2, int n3, int n4) {
        TextureUtil.prepareImage(b2, n2, 0, n3, n4);
    }

    public static void prepareImage(int n2, int n3, int n4, int n5) {
        TextureUtil.prepareImage(ctp.b.a, n2, n3, n4, n5);
    }

    public static void prepareImage(ctp.b b2, int n2, int n3, int n4, int n5) {
        TextureUtil.bind(n2);
        if (n3 >= 0) {
            GlStateManager.texParameter(3553, 33085, n3);
            GlStateManager.texParameter(3553, 33082, 0);
            GlStateManager.texParameter(3553, 33083, n3);
            GlStateManager.texParameter(3553, 34049, 0.0f);
        }
        for (\u2603 = 0; \u2603 <= n3; ++\u2603) {
            GlStateManager.texImage2D(3553, \u2603, b2.a(), n4 >> \u2603, n5 >> \u2603, 0, 6408, 5121, null);
        }
    }

    private static void bind(int n2) {
        GlStateManager.bindTexture(n2);
    }

    public static ByteBuffer readResource(InputStream inputStream) throws IOException {
        ByteBuffer \u26033;
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel \u26032 = fileInputStream.getChannel();
            \u26033 = MemoryUtil.memAlloc((int)((int)\u26032.size() + 1));
            while (\u26032.read(\u26033) != -1) {
            }
        } else {
            \u26033 = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel \u26034 = Channels.newChannel(inputStream);
            while (\u26034.read(\u26033) != -1) {
                if (\u26033.remaining() != 0) continue;
                \u26033 = MemoryUtil.memRealloc((ByteBuffer)\u26033, (int)(\u26033.capacity() * 2));
            }
        }
        return \u26033;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceAsString(InputStream inputStream) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = TextureUtil.readResource(inputStream);
            int n2 = byteBuffer.position();
            byteBuffer.rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)byteBuffer, (int)n2);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (byteBuffer != null) {
                MemoryUtil.memFree((Buffer)byteBuffer);
            }
        }
        return null;
    }

    public static void writeAsPNG(String string, int n2, int n3, int n4, int n5) {
        TextureUtil.bind(n2);
        for (\u2603 = 0; \u2603 <= n3; ++\u2603) {
            String string2 = string + "_" + \u2603 + ".png";
            int \u26032 = n4 >> \u2603;
            int \u26033 = n5 >> \u2603;
            try (ctp ctp2 = new ctp(\u26032, \u26033, false);){
                ctp2.a(\u2603, false);
                ctp2.a(string2);
                LOGGER.debug("Exported png to: {}", (Object)new File(string2).getAbsolutePath());
                continue;
            }
            catch (IOException iOException) {
                LOGGER.debug("Unable to write: ", (Throwable)iOException);
            }
        }
    }

    public static void initTexture(IntBuffer intBuffer, int n2, int n3) {
        GL11.glPixelStorei((int)3312, (int)0);
        GL11.glPixelStorei((int)3313, (int)0);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3317, (int)4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)n2, (int)n3, (int)0, (int)32993, (int)33639, (IntBuffer)intBuffer);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
    }
}

