/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TextRenderingUtils {
    private TextRenderingUtils() {
    }

    static List<String> lineBreak(String text) {
        return Arrays.asList(text.split("\\n"));
    }

    public static List<Line> decompose(String text, LineSegment ... links) {
        return TextRenderingUtils.decompose(text, Arrays.asList(links));
    }

    private static List<Line> decompose(String text, List<LineSegment> links) {
        List<String> brokenLines = TextRenderingUtils.lineBreak(text);
        return TextRenderingUtils.insertLinks(brokenLines, links);
    }

    private static List<Line> insertLinks(List<String> lines, List<LineSegment> links) {
        int linkCount = 0;
        ArrayList<Line> processedLines = new ArrayList<Line>();
        for (String line : lines) {
            ArrayList<LineSegment> segments = new ArrayList<LineSegment>();
            List<String> parts = TextRenderingUtils.split(line, "%link");
            for (String part : parts) {
                if (part.equals("%link")) {
                    segments.add(links.get(linkCount++));
                    continue;
                }
                segments.add(LineSegment.text(part));
            }
            processedLines.add(new Line(segments));
        }
        return processedLines;
    }

    public static List<String> split(String line, String delimiter) {
        int matchIndex;
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter cannot be the empty string");
        }
        ArrayList<String> parts = new ArrayList<String>();
        int searchStart = 0;
        while ((matchIndex = line.indexOf(delimiter, searchStart)) != -1) {
            if (matchIndex > searchStart) {
                parts.add(line.substring(searchStart, matchIndex));
            }
            parts.add(delimiter);
            searchStart = matchIndex + delimiter.length();
        }
        if (searchStart < line.length()) {
            parts.add(line.substring(searchStart));
        }
        return parts;
    }

    public static class LineSegment {
        final String fullText;
        final String linkTitle;
        final String linkUrl;

        private LineSegment(String fullText) {
            this.fullText = fullText;
            this.linkTitle = null;
            this.linkUrl = null;
        }

        private LineSegment(String fullText, String linkTitle, String linkUrl) {
            this.fullText = fullText;
            this.linkTitle = linkTitle;
            this.linkUrl = linkUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineSegment segment = (LineSegment)o;
            return Objects.equals(this.fullText, segment.fullText) && Objects.equals(this.linkTitle, segment.linkTitle) && Objects.equals(this.linkUrl, segment.linkUrl);
        }

        public int hashCode() {
            return Objects.hash(this.fullText, this.linkTitle, this.linkUrl);
        }

        public String toString() {
            return "Segment{fullText='" + this.fullText + '\'' + ", linkTitle='" + this.linkTitle + '\'' + ", linkUrl='" + this.linkUrl + '\'' + '}';
        }

        public String renderedText() {
            return this.isLink() ? this.linkTitle : this.fullText;
        }

        public boolean isLink() {
            return this.linkTitle != null;
        }

        public String getLinkUrl() {
            if (!this.isLink()) {
                throw new IllegalStateException("Not a link: " + this);
            }
            return this.linkUrl;
        }

        public static LineSegment link(String linkTitle, String linkUrl) {
            return new LineSegment(null, linkTitle, linkUrl);
        }

        static LineSegment text(String fullText) {
            return new LineSegment(fullText);
        }
    }

    public static class Line {
        public final List<LineSegment> segments;

        Line(LineSegment ... segments) {
            this(Arrays.asList(segments));
        }

        Line(List<LineSegment> segments) {
            this.segments = segments;
        }

        public String toString() {
            return "Line{segments=" + this.segments + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            return Objects.equals(this.segments, line.segments);
        }

        public int hashCode() {
            return Objects.hash(this.segments);
        }
    }
}

