/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.spase;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.xerces.parsers.DOMParser;
import org.virbo.spase.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMTreeWalkerTreeModel
implements TreeModel {
    TreeWalker walker;

    public DOMTreeWalkerTreeModel(TreeWalker walker) {
        this.walker = walker;
    }

    public DOMTreeWalkerTreeModel(Document document) {
        DocumentTraversal dt = (DocumentTraversal)((Object)document);
        this.walker = dt.createTreeWalker(document, -1, null, false);
    }

    public DOMTreeWalkerTreeModel(Element element) {
        DocumentTraversal dt = (DocumentTraversal)((Object)element.getOwnerDocument());
        this.walker = dt.createTreeWalker(element, -1, null, false);
    }

    public Object getRoot() {
        return new TreeNode(this.walker.getRoot());
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public int getChildCount(Object node) {
        this.walker.setCurrentNode(((TreeNode)node).getDomNode());
        int numkids = 0;
        Node child = this.walker.firstChild();
        while (child != null) {
            ++numkids;
            child = this.walker.nextSibling();
        }
        return numkids;
    }

    public Object getChild(Object parent, int index) {
        this.walker.setCurrentNode(((TreeNode)parent).getDomNode());
        Node child = this.walker.firstChild();
        while (index-- > 0) {
            child = this.walker.nextSibling();
        }
        return new TreeNode(child);
    }

    public int getIndexOfChild(Object parent, Object child) {
        this.walker.setCurrentNode(((TreeNode)parent).getDomNode());
        int index = 0;
        Node c = this.walker.firstChild();
        while (c != child && c != null) {
            ++index;
            c = this.walker.nextSibling();
        }
        return index;
    }

    public void valueForPathChanged(TreePath path, Object newvalue) {
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public static void main(String[] args) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        BufferedReader in = new BufferedReader(new FileReader(args[0]));
        InputSource input = new InputSource(in);
        parser.parse(input);
        Document document = parser.getDocument();
        DocumentTraversal traversal = (DocumentTraversal)((Object)document);
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        int whatToShow = -129;
        TreeWalker walker = traversal.createTreeWalker(document, whatToShow, filter, false);
        JTree tree = new JTree(new DOMTreeWalkerTreeModel(walker));
        JFrame frame = new JFrame("DOMTreeWalkerTreeModel Demo");
        frame.getContentPane().add(new JScrollPane(tree));
        frame.setSize(500, 250);
        frame.setVisible(true);
    }
}

