/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.das2Stream;

import edu.uiowa.physics.pw.das.client.DataSetStreamHandler;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.util.StreamTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetAdapter;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.MetadataModel;

public class Das2StreamDataSource
extends AbstractDataSource {
    public Das2StreamDataSource(URL url) throws IOException {
        super(url);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws FileNotFoundException, StreamException, IOException {
        File f = this.getFile(mon);
        FileInputStream in = new FileInputStream(f);
        ReadableByteChannel channel = Channels.newChannel(in);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("file", this.url.toString());
        DataSetStreamHandler handler = new DataSetStreamHandler(props, mon);
        StreamTool.readStream((ReadableByteChannel)channel, (StreamHandler)handler);
        ((InputStream)in).close();
        return DataSetAdapter.create((DataSet)handler.getDataSet());
    }

    public boolean asynchronousLoad() {
        return true;
    }

    public static DataSourceFactory getFactory() {
        return new DataSourceFactory(){

            public DataSource getDataSource(URL url) throws IOException {
                return new Das2StreamDataSource(url);
            }

            public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) {
                return Collections.emptyList();
            }

            public MetadataModel getMetadataModel(URL url) {
                return MetadataModel.createNullModel();
            }

            public boolean reject(String surl, ProgressMonitor mon) {
                return false;
            }

            public String urlForServer(String surl) {
                return surl;
            }
        };
    }
}

