/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import edu.uiowa.physics.pw.das.datum.Units;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.datasource.DataSourceFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableDataSourceFormat
implements DataSourceFormat {
    private void maybeOutputProperty(PrintWriter out, QDataSet data, String property) {
        Object v = data.property(property);
        if (v != null) {
            out.println("# " + property + ": " + v);
        }
    }

    private void formatRank2(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        out.println("# Generated by Autoplot on " + new Date());
        this.maybeOutputProperty(out, data, "TITLE");
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep1 != null) {
            int i;
            Units u;
            out.print("#");
            if (dep0 != null) {
                String l = (String)dep0.property("LABEL");
                out.print(" " + (l == null ? "dep0" : l) + ", ");
            }
            if ((u = (Units)dep1.property("UNITS")) == null) {
                u = Units.dimensionless;
            }
            for (i = 0; i < dep1.length() - 1; ++i) {
                out.print(u == null ? "" + dep1.value(i) : u.createDatum(dep1.value(i)) + ", ");
            }
            out.println((Object)(u == null ? "" + dep1.value(i) : u.createDatum(dep1.value(i))));
        }
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        Units u = (Units)data.property("UNITS");
        mon.setTaskSize((long)data.length());
        mon.started();
        for (int i = 0; i < data.length(); ++i) {
            int j;
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                out.print("" + u0.createDatum(dep0.value(i)) + ", ");
            }
            for (j = 0; j < data.length(i) - 1; ++j) {
                out.print(u.createDatum(data.value(i, j)) + ", ");
            }
            out.println(u.createDatum(data.value(i, j)));
        }
        mon.finished();
    }

    private void formatRank1(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        String l;
        out.println("# Generated by Autoplot on " + new Date());
        this.maybeOutputProperty(out, data, "TITLE");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        out.print("#");
        if (dep0 != null) {
            l = (String)dep0.property("LABEL");
            out.print(" " + (l == null ? "dep0" : l));
        }
        l = (String)dep0.property("LABEL");
        out.println(" " + (l == null ? "data" : l));
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        Units u = (Units)data.property("UNITS");
        mon.setTaskSize((long)data.length());
        mon.started();
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                out.print("" + u0.createDatum(dep0.value(i)) + ", ");
            }
            out.println(u.createDatum(data.value(i)));
        }
        mon.finished();
    }

    public void formatData(File url, Map<String, String> params, QDataSet data, ProgressMonitor mon) throws IOException {
        PrintWriter out = new PrintWriter(url);
        if (data.rank() == 2) {
            this.formatRank2(out, data, mon);
        } else if (data.rank() == 1) {
            this.formatRank1(out, data, mon);
        }
        out.close();
    }
}

