/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.ascii.AsciiTableDataSource;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsutil.AsciiParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URL url) throws FileNotFoundException, IOException {
        return new AsciiTableDataSource(url);
    }

    public String editPanel(String surl) throws Exception {
        return surl;
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "skip="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "fixedColumns="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "rank2"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "time="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timeFormat=", "template for parsing time digits, default is ISO8601."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend0="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "fill="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "comment=", "comment line prefix, default is hash (#)"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMin=", "values less than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "validMax=", "values greater than this value are treated as fill."));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "delim=", "parse records by splitting on delimiter."));
            return result;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (paramName.equals("skip")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "the number of lines to skip before attempting to parse."));
            }
            if (paramName.equals("rank2")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>"));
            }
            if (paramName.equals("column")) {
                String[] columns = this.getFieldNames(cc, mon);
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                for (String s : columns) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s));
                }
                return result;
            }
            if (paramName.equals("fixedColumns")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", "Hint at the number of columns to expect, then use fast parser that assumes fixed columns."));
            }
            if (paramName.equals("time")) {
                String[] columns = this.getFieldNames(cc, mon);
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                for (String s : columns) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s));
                }
                return result;
            }
            if (paramName.equals("depend0")) {
                String[] columns = this.getFieldNames(cc, mon);
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                for (String s : columns) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s));
                }
                return result;
            }
            if (paramName.equals("timeFormat")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "%Y %j %H"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "ISO8601"));
                return result;
            }
            if (paramName.equals("fill")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
            if (paramName.equals("validMin")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
            if (paramName.equals("validMax")) {
                return Collections.singletonList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
            if (paramName.equals("rank2")) {
                ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:", "all but first column"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "1:5", "second through 5th columns"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "-5:", "last five columns"));
                return result;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        return false;
    }

    public String urlForServer(String surl) {
        return surl;
    }

    private String[] getFieldNames(CompletionContext cc, ProgressMonitor mon) throws IOException {
        LinkedHashMap params = DataSetURL.parseParams((String)cc.params);
        File file = DataSetURL.getFile((URL)cc.resource, (ProgressMonitor)mon);
        AsciiParser parser = AsciiParser.newParser((int)5);
        if (params.containsKey("skip")) {
            parser.setSkipLines(Integer.parseInt((String)params.get("skip")));
        }
        parser.guessDelimParser(parser.readFirstRecord(file.toString()));
        return parser.getFieldNames();
    }
}

