/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.TimeParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURL;
import org.virbo.dsutil.AsciiParser;
import org.virbo.metatree.MetadataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiTableDataSource
extends AbstractDataSource {
    AsciiParser parser;
    File file;
    String column = null;
    String depend0 = null;
    TimeParser timeParser;
    int timeColumns = -1;
    int timeColumn = -1;
    DDataSet ds = null;
    int[] rank2 = null;
    private double validMin = Double.NEGATIVE_INFINITY;
    private double validMax = Double.POSITIVE_INFINITY;

    public AsciiTableDataSource(URL url) throws FileNotFoundException, IOException {
        super(url);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws IOException {
        int icol;
        this.ds = this.doReadFile(mon);
        if (this.timeColumns > 1) {
            TimeLocationUnits u = Units.t2000;
            for (int i = 0; i < this.ds.length(); ++i) {
                for (int j = 0; j < this.timeColumns; ++j) {
                    this.timeParser.setDigit(j, (int)this.ds.value(i, this.timeColumn + j));
                }
                this.ds.putValue(i, this.timeColumn, this.timeParser.getTime((Units)Units.t2000));
            }
            this.parser.setUnits(this.timeColumn, (Units)Units.t2000);
        }
        DDataSet vds = null;
        DDataSet dep0 = null;
        if (this.column != null) {
            icol = this.parser.getFieldIndex(this.column);
            if (icol == -1 && Pattern.matches("field[0-9]+", this.column)) {
                icol = Integer.parseInt(this.column.substring(5));
            }
            vds = DDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
            vds.putProperty("UNITS", (Object)this.parser.getUnits(icol));
            if (this.validMax != Double.POSITIVE_INFINITY) {
                vds.putProperty("VALID_MAX", (Object)this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                vds.putProperty("VALID_MIN", (Object)this.validMin);
            }
        }
        if (this.depend0 != null) {
            icol = this.parser.getFieldIndex(this.depend0);
            dep0 = DDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)this.ds, (int)icol));
            dep0.putProperty("UNITS", (Object)this.parser.getUnits(icol));
            if (DataSetUtil.isMonotonic((QDataSet)dep0)) {
                dep0.putProperty("MONOTONIC", (Object)Boolean.TRUE);
            }
        }
        if (this.rank2 != null) {
            if (dep0 != null) {
                this.ds.putProperty("DEPEND_0", dep0);
            }
            this.ds.putProperty("UNITS", (Object)this.parser.getUnits(this.rank2[0]));
            if (this.validMax != Double.POSITIVE_INFINITY) {
                this.ds.putProperty("VALID_MAX", (Object)this.validMax);
            }
            if (this.validMin != Double.NEGATIVE_INFINITY) {
                this.ds.putProperty("VALID_MIN", (Object)this.validMin);
            }
            return DataSetOps.leafTrim((QDataSet)this.ds, (int)this.rank2[0], (int)this.rank2[1]);
        }
        if (vds == null) {
            throw new IllegalArgumentException("didn't find column: " + this.column);
        }
        if (dep0 != null) {
            vds.putProperty("DEPEND_0", dep0);
        }
        return vds;
    }

    private DDataSet doReadFile(ProgressMonitor mon) throws NumberFormatException, IOException, FileNotFoundException {
        String s;
        String delim;
        this.file = DataSetURL.getFile((URL)this.url, (ProgressMonitor)mon);
        this.parser = new AsciiParser();
        boolean fixedColumns = false;
        int columnCount = 0;
        Object o = this.params.get("skip");
        if (o != null) {
            this.parser.setSkipLines(Integer.parseInt((String)o));
        }
        this.parser.setKeepFileHeader(true);
        o = this.params.get("comment");
        if (o != null) {
            this.parser.setCommentPrefix((String)o);
        }
        if ((delim = (o = this.params.get("delim")) != null ? (String)o : null) == null) {
            AsciiParser.DelimParser p = this.parser.guessDelimParser(this.parser.readFirstRecord(this.file.toString()));
            columnCount = p.fieldCount();
            delim = p.getDelim();
        } else {
            columnCount = this.parser.setDelimParser(this.file.toString(), delim).fieldCount();
        }
        this.parser.setPropertyPattern(AsciiParser.NAME_COLON_VALUE_PATTERN);
        o = this.params.get("fixedColumns");
        if (o != null) {
            String s2 = (String)o;
            AsciiParser.FixedColumnsParser p = this.parser.setFixedColumnsParser(this.file.toString(), "\\s+");
            if (o.equals("")) {
                columnCount = p.fieldCount();
            } else if (s2.contains(",")) {
                String[] ss = s2.split(",");
                int[] starts = new int[ss.length];
                int[] widths = new int[ss.length];
                AsciiParser.FieldParser[] fparsers = new AsciiParser.FieldParser[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    String[] ss2 = ss[i].split("-");
                    starts[i] = Integer.parseInt(ss2[0]);
                    widths[i] = Integer.parseInt(ss2[1]) - starts[i];
                    fparsers[i] = AsciiParser.DOUBLE_PARSER;
                }
                p = this.parser.setFixedColumnsParser(starts, widths, fparsers);
            } else {
                columnCount = Integer.parseInt((String)o);
            }
            this.parser.setPropertyPattern(null);
            fixedColumns = true;
            delim = null;
        }
        o = this.params.get("columnCount");
        if (columnCount == 0) {
            columnCount = o != null ? Integer.parseInt((String)o) : AsciiParser.guessFieldCount((String)this.file.toString());
        }
        if ((o = this.params.get("fill")) != null) {
            this.parser.setFillValue(Double.parseDouble((String)o));
        }
        if ((o = this.params.get("validMin")) != null) {
            this.validMin = Double.parseDouble((String)o);
        }
        if ((o = this.params.get("validMax")) != null) {
            this.validMax = Double.parseDouble((String)o);
        }
        if ((o = this.params.get("time")) != null) {
            int i = this.parser.getFieldIndex((String)o);
            if (i == -1) {
                System.err.println("field not found for time parameter: " + o);
            } else {
                this.parser.setFieldParser(i, this.parser.UNITS_PARSER);
                this.parser.setUnits(i, (Units)Units.t2000);
                this.depend0 = (String)o;
                this.timeColumn = i;
            }
        }
        if ((o = this.params.get("timeFormat")) != null) {
            String timeFormat = (String)o;
            this.timeParser = TimeParser.create((String)((String)o));
            String timeColumnName = (String)this.params.get("time");
            int n = this.timeColumn = timeColumnName == null ? 0 : this.parser.getFieldIndex(timeColumnName);
            if (delim != null && timeFormat.split(delim, -2).length > 1) {
                this.timeColumns = timeFormat.split("%", -2).length - 1;
                int ib = timeFormat.indexOf("%b");
                if (ib != -1) {
                    int monthColumn = timeFormat.substring(0, ib).split("%", -2).length - 1;
                    AsciiParser.FieldParser monthNameFieldParser = new AsciiParser.FieldParser(){

                        public double parseField(String field, int columnIndex) throws ParseException {
                            return TimeUtil.monthNumber((String)field);
                        }
                    };
                    this.parser.setFieldParser(monthColumn, monthNameFieldParser);
                }
            } else {
                TimeLocationUnits u = Units.t2000;
                this.parser.setUnits(this.timeColumn, (Units)u);
                AsciiParser.FieldParser timeFieldParser = new AsciiParser.FieldParser((Units)u){
                    final /* synthetic */ Units val$u;
                    {
                        this.val$u = units;
                    }

                    public double parseField(String field, int fieldIndex) throws ParseException {
                        return AsciiTableDataSource.this.timeParser.parse(field).getTime(this.val$u);
                    }
                };
                this.parser.setFieldParser(this.timeColumn, timeFieldParser);
            }
        } else {
            this.timeParser = null;
        }
        o = this.params.get("depend0");
        if (o != null) {
            this.depend0 = (String)o;
        }
        if ((o = this.params.get("column")) != null) {
            this.column = (String)o;
        }
        if ((o = this.params.get("rank2")) != null) {
            String s3 = (String)o;
            int first = 0;
            int last = columnCount;
            if (s3.contains(":")) {
                String[] ss = s3.split(":");
                if (ss[0].length() > 0 && (first = Integer.parseInt(ss[0])) < 0) {
                    first = columnCount + first;
                }
                if (ss.length > 1 && ss[1].length() > 0 && (last = Integer.parseInt(ss[1])) < 0) {
                    last = columnCount + last;
                }
            }
            this.rank2 = new int[]{first, last};
            this.column = null;
        }
        if ((o = this.params.get("arg_0")) != null && o.equals("rank2")) {
            this.rank2 = new int[]{0, columnCount};
            this.column = null;
        }
        if (this.column == null && this.depend0 == null && this.rank2 == null) {
            if (this.parser.getFieldNames().length > 1) {
                this.depend0 = this.parser.getFieldNames()[0];
                this.column = this.parser.getFieldNames()[1];
            } else {
                this.column = this.parser.getFieldNames()[0];
            }
        }
        if (this.timeColumn == -1 && this.depend0 != null && (s = this.parser.readFirstParseableRecord(this.file.toString())) != null) {
            String[] fields = this.parser.getRecordParser().fields(s);
            int idep0 = this.parser.getFieldIndex(this.depend0);
            if (idep0 != -1) {
                String field = fields[idep0];
                try {
                    Units.us2000.parse(field);
                    this.parser.setUnits(idep0, (Units)Units.us2000);
                    this.parser.setFieldParser(idep0, this.parser.UNITS_PARSER);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        if ((o = this.params.get("units")) != null) {
            String sunits = (String)o;
            Units u = MetadataUtil.lookupUnits((String)sunits);
            if (this.column != null) {
                int icol = this.parser.getFieldIndex(this.column);
                this.parser.setUnits(icol, u);
                this.parser.setFieldParser(icol, this.parser.UNITS_PARSER);
            }
        }
        DDataSet ds1 = (DDataSet)this.parser.readFile(this.file.toString(), mon);
        return ds1;
    }

    public Map<String, Object> getMetaData(ProgressMonitor mon) throws Exception {
        if (this.ds == null) {
            return new HashMap<String, Object>();
        }
        Map props = (Map)this.ds.property("USER_PROPERTIES");
        return props;
    }
}

