/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.graph.GraphUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import org.virbo.cefdatasource.Cef;
import org.virbo.cefdatasource.CefReaderData;
import org.virbo.cefdatasource.CefReaderHeader;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.VectorDataSetAdapter;

public class TestCefReader {
    public static void main(String[] args) throws IOException, ParseException {
        System.err.println(new File("../..").toURI().toURL().toString());
        String file1 = "C1_CP_EDI_EGD__20050212_V03.cef";
        String file2 = "C1_CP_EDI_EGD__20050217_V03.cef";
        String file3 = "C1_PP_CIS__20020707_V03.cef";
        String file4 = "C1_CP_PEA_CP3DXPH_DNFlux__20020811_140000_20020811_150000_V061018.cef";
        String file5 = "C1_CP_PEA_CP3DXPH_DNFlux__20020811_140000_20020811_141000_V061018.cef";
        File file = new File("../../../data/cef/" + file5);
        long fileSize = file.length();
        FileInputStream in = new FileInputStream(file);
        ReadableByteChannel channel = Channels.newChannel(in);
        long t0 = System.currentTimeMillis();
        CefReaderHeader reader = new CefReaderHeader();
        Cef cef = reader.read(channel);
        System.err.println("time to read Cef header (ms): " + (System.currentTimeMillis() - t0));
        DDataSet result = new CefReaderData().cefReadData(channel, cef);
        long dt = System.currentTimeMillis() - t0;
        System.err.println("time to read Cef data (ms): " + dt + "  (" + fileSize / dt + " KB/sec)");
        System.err.println(result);
        MutablePropertyDataSet ds = DataSetOps.slice1((QDataSet)result, (int)1);
        GraphUtil.visualize((DataSet)VectorDataSetAdapter.create((QDataSet)ds));
    }
}

