/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import java.nio.ByteBuffer;

public class DoubleParser {
    private static boolean match(String str, byte[] csq, int start, int length) {
        for (int i = 0; i < str.length(); ++i) {
            if (start + i < length && csq[start + i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean match(String str, ByteBuffer csq, int start, int length) {
        for (int i = 0; i < str.length(); ++i) {
            if (start + i < length && csq.get(start + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static double parseDoubleByteArray(ByteBuffer csq, int start, int length) throws NumberFormatException {
        boolean isNegative;
        int i = start;
        int fin = start + length;
        char c = (char)csq.get(i);
        while (Character.isWhitespace(c) && i < fin) {
            c = (char)csq.get(++i);
        }
        if (c == 'N' && DoubleParser.match("NaN", csq, i, 3)) {
            return Double.NaN;
        }
        boolean bl = isNegative = c == '-';
        if ((isNegative || c == '+') && ++i < fin) {
            c = (char)csq.get(i);
        }
        if (c == 'I' && DoubleParser.match("Infinity", csq, i, 8)) {
            return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long decimal = 0L;
        int decimalPoint = -1;
        while (true) {
            int digit;
            if ((digit = c - 48) >= 0 && digit < 10) {
                long tmp = decimal * 10L + (long)digit;
                if (tmp < decimal) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                decimal = tmp;
            } else {
                if (c != '.' || decimalPoint >= 0) break;
                decimalPoint = i;
            }
            if (++i >= fin) break;
            c = (char)csq.get(i);
        }
        if (isNegative) {
            decimal = -decimal;
        }
        int fractionLength = decimalPoint >= 0 ? i - decimalPoint - 1 : 0;
        int exp = 0;
        if (i < fin && (c == 'E' || c == 'e')) {
            int digit;
            boolean isNegativeExp;
            boolean bl2 = isNegativeExp = (c = (char)csq.get(++i)) == '-';
            if ((isNegativeExp || c == '+') && ++i < fin) {
                c = (char)csq.get(i);
            }
            while ((digit = c - 48) >= 0 && digit < 10) {
                int tmp = exp * 10 + digit;
                if (tmp < exp) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                exp = tmp;
                if (++i >= fin) break;
                c = (char)csq.get(i);
            }
            if (isNegativeExp) {
                exp = -exp;
            }
        }
        return (double)decimal * Math.pow(10.0, exp - fractionLength);
    }
}

