/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankNDataSet;

public class DataSetOps {
    public static DDataSet collapse(QDataSet ds) {
        DDataSet result;
        double fill;
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        Units u = (Units)ds.property("UNITS");
        double d = fill = u == null ? Double.NaN : u.getFillDouble();
        if (ds.rank() == 4) {
            result = DDataSet.createRank3((int)qube[0], (int)qube[1], (int)qube[2]);
            for (int i = 0; i < ds.length(); ++i) {
                QDataSet slice = ((RankNDataSet)ds).slice(i);
                for (int j = 0; j < slice.length(); ++j) {
                    for (int k = 0; k < slice.length(i); ++k) {
                        double ssum = 0.0;
                        double wsum = 0.0;
                        for (int l = 0; l < ds.length(i, j); ++l) {
                            double d2 = ds.value(j, k, l);
                            double w = u == null || u.isValid(d2) ? 1.0 : 0.0;
                            ssum += d2 * w;
                            wsum += w;
                        }
                        ssum = wsum == 0.0 ? fill : ssum / wsum;
                        result.putValue(i, j, k, ssum);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("only rank 4 supported");
        }
        DataSetUtil.putProperties((Map)DataSetUtil.getProperties((QDataSet)ds), (MutablePropertyDataSet)result);
        return result;
    }

    public static DDataSet collapse1(QDataSet ds) {
        DDataSet result;
        double fill;
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        Units u = (Units)ds.property("UNITS");
        double d = fill = u == null ? Double.NaN : u.getFillDouble();
        if (ds.rank() == 3) {
            result = DDataSet.createRank2((int)qube[0], (int)qube[2]);
            for (int i = 0; i < ds.length(); ++i) {
                for (int k = 0; k < ds.length(i, 0); ++k) {
                    double ssum = 0.0;
                    double wsum = 0.0;
                    for (int j = 0; j < ds.length(0); ++j) {
                        double d2 = ds.value(i, j, k);
                        double w = u == null || u.isValid(d2) ? 1.0 : 0.0;
                        ssum += d2 * w;
                        wsum += w;
                    }
                    ssum = wsum == 0.0 ? fill : ssum / wsum;
                    result.putValue(i, k, ssum);
                }
            }
        } else {
            throw new IllegalArgumentException("only rank 3 supported");
        }
        DataSetUtil.putProperties((Map)DataSetUtil.getProperties((QDataSet)ds), (MutablePropertyDataSet)result);
        result.putProperty("DEPEND_1", result.property("DEPEND_2"));
        return result;
    }

    public static DDataSet collapse2(QDataSet ds) {
        DDataSet result;
        double fill;
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        Units u = (Units)ds.property("UNITS");
        double d = fill = u == null ? Double.NaN : u.getFillDouble();
        if (ds.rank() == 4) {
            result = DDataSet.createRank3((int)qube[0], (int)qube[1], (int)qube[3]);
            for (int i = 0; i < ds.length(); ++i) {
                QDataSet slice = ((RankNDataSet)ds).slice(i);
                for (int j = 0; j < slice.length(); ++j) {
                    for (int l = 0; l < slice.length(i, j); ++l) {
                        double ssum = 0.0;
                        double wsum = 0.0;
                        for (int k = 0; k < slice.length(i); ++k) {
                            double d2 = slice.value(j, k, l);
                            double w = u == null || u.isValid(d2) ? 1.0 : 0.0;
                            ssum += d2 * w;
                            wsum += w;
                        }
                        ssum = wsum == 0.0 ? fill : ssum / wsum;
                        result.putValue(i, j, l, ssum);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("only rank 4 supported");
        }
        DataSetUtil.putProperties((Map)DataSetUtil.getProperties((QDataSet)ds), (MutablePropertyDataSet)result);
        result.putProperty("DEPEND_2", result.property("DEPEND_3"));
        return result;
    }
}

