/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import edu.uiowa.physics.pw.das.datum.Units;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.ParseException;
import org.virbo.cefdatasource.Cef;
import org.virbo.cefdatasource.DoubleFieldParser;
import org.virbo.cefdatasource.FieldParser;
import org.virbo.cefdatasource.IsoTimeParser;
import org.virbo.dataset.DDataSet;
import org.virbo.dsutil.DataSetBuilder;

public class CefReaderData {
    Cef cef;
    FieldParser[] parsers;
    CharsetDecoder charsetDecoder;
    byte eor;
    byte comma = (byte)44;
    final Units u = Units.us2000;
    public static final int MAX_FIELDS = 40000;
    boolean[] doParse = new boolean[40000];

    public CefReaderData() {
        Charset charset = (Charset)Charset.availableCharsets().get("US-ASCII");
        this.charsetDecoder = charset.newDecoder();
        for (int i = 0; i < this.doParse.length; ++i) {
            this.doParse[i] = true;
        }
    }

    public void skipParse(int i) {
        this.doParse[i] = false;
    }

    public void doParse(int i) {
        this.doParse[i] = true;
    }

    private final int countFields(ByteBuffer work_buffer) {
        int n_fields = 1;
        int k = 0;
        while (true) {
            if (work_buffer.get(k) == this.comma) {
                ++n_fields;
            } else if (work_buffer.get(k) == this.eor) break;
            ++k;
        }
        return n_fields;
    }

    private final int getLastEor(ByteBuffer work_buffer) {
        int pos_eor;
        for (pos_eor = work_buffer.limit() - 1; pos_eor >= 0 && work_buffer.get(pos_eor) != this.eor; --pos_eor) {
        }
        return pos_eor;
    }

    private void parseRecord(ByteBuffer bbuf, int irec, int[] fieldDelim, DataSetBuilder builder) throws CharacterCodingException, ParseException {
        for (int i = 0; i < fieldDelim.length - 1; ++i) {
            if (this.parsers[i] == null) continue;
            builder.putValue(irec, i, this.parsers[i].parseField(bbuf, fieldDelim[i], fieldDelim[i + 1] - fieldDelim[i] - 1));
        }
    }

    private void removeComments(ByteBuffer work_buffer, int work_size) {
        byte comment = 33;
        byte eol = 10;
        int pos_comment = 0;
        for (pos_comment = 0; pos_comment < work_size; ++pos_comment) {
            byte ch = work_buffer.get(pos_comment);
            if (ch == comment) {
                int j;
                for (j = pos_comment; j < work_size && work_buffer.get(j) != eol; ++j) {
                    work_buffer.put(j, (byte)32);
                }
                work_buffer.put(j, (byte)32);
                pos_comment = j;
                continue;
            }
            if (ch == eol && this.eor != eol) {
                work_buffer.put(pos_comment, (byte)32);
                continue;
            }
            if (ch != this.eor) continue;
        }
    }

    private void getParsers(ByteBuffer work_buffer, int work_size, FieldParser[] parsers) {
        int n_fields = parsers.length;
        int[] fieldDelim = new int[n_fields + 1];
        this.splitRecord(work_buffer, 0, work_size, fieldDelim);
        for (int i = 0; i < n_fields; ++i) {
            parsers[i] = this.doParse[i] ? new DoubleFieldParser() : null;
        }
        IsoTimeParser timeParser = fieldDelim[1] > 27 ? new IsoTimeParser(6) : new IsoTimeParser(3);
        parsers[0] = timeParser;
    }

    private int splitRecord(ByteBuffer work_buffer, int recPos, int work_size, int[] fieldDelim) {
        int ifield = 0;
        fieldDelim[0] = recPos;
        while (recPos < work_size && work_buffer.get(recPos) != this.eor) {
            if (work_buffer.get(recPos) == this.comma) {
                fieldDelim[++ifield] = recPos + 1;
            }
            ++recPos;
        }
        if (fieldDelim[0] > fieldDelim[1]) {
            System.err.println("here232");
        }
        return recPos;
    }

    public DDataSet cefReadData(ReadableByteChannel lun, Cef cef) throws IOException, ParseException {
        System.err.println("Reading data records, please wait...");
        this.eor = cef.eor;
        int buffer_size = 200000;
        byte[] work_buf = new byte[2 * buffer_size];
        ByteBuffer read_buffer = ByteBuffer.wrap(new byte[buffer_size]);
        ByteBuffer work_buffer = ByteBuffer.wrap(work_buf);
        int work_size = 0;
        Cef cef1 = new Cef();
        cef1.nparam = 1;
        boolean flag = true;
        int trflag = 1;
        int n_fields = 0;
        boolean eof = false;
        int irec = 0;
        DataSetBuilder builder = null;
        long totalBytesRead = 0L;
        while (!eof && trflag > 0) {
            read_buffer.rewind();
            int read_size = lun.read(read_buffer);
            if (read_size == -1) {
                eof = true;
                break;
            }
            totalBytesRead += (long)read_size;
            if (read_size > 0) {
                read_buffer.flip();
                work_buffer.put(read_buffer);
                work_buffer.flip();
            }
            work_size += read_size;
            int pos_eor = this.getLastEor(work_buffer);
            if (pos_eor <= -1) break;
            work_size = pos_eor;
            this.removeComments(work_buffer, work_size);
            pos_eor = this.getLastEor(work_buffer);
            if (pos_eor <= -1) {
                throw new IllegalArgumentException("the entire work buffer was a comment, this is not handled.");
            }
            work_size = pos_eor;
            n_fields = this.countFields(work_buffer);
            if (builder == null) {
                builder = new DataSetBuilder(2, 100, n_fields, 1);
                this.parsers = new FieldParser[n_fields];
                this.getParsers(work_buffer, work_size, this.parsers);
            }
            int[] fieldDelim = new int[n_fields + 1];
            fieldDelim[0] = 0;
            int pos = 0;
            while (pos < work_size) {
                int recPos = pos;
                if ((recPos = this.splitRecord(work_buffer, recPos, work_size, fieldDelim)) > work_size) break;
                fieldDelim[n_fields] = recPos + 1;
                this.parseRecord(work_buffer, irec, fieldDelim, builder);
                pos = recPos + 1;
                work_buffer.position(pos);
                builder.nextRecord();
                ++irec;
            }
            work_buffer.compact();
            work_size = work_buffer.position();
            if (read_size >= buffer_size) continue;
            flag = false;
        }
        work_buffer = null;
        read_buffer = null;
        System.err.println("Reading of data complete");
        return builder == null ? null : builder.getDataSet();
    }
}

