/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cefdatasource;

import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitorReadableByteChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cefdatasource.Cef;
import org.virbo.cefdatasource.CefMetadataModel;
import org.virbo.cefdatasource.CefReaderData;
import org.virbo.cefdatasource.CefReaderHeader;
import org.virbo.cefdatasource.DataSetOps;
import org.virbo.cefdatasource.ReformDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SortDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsutil.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CefDataSource
extends AbstractDataSource {
    Cef cef;

    public CefDataSource(URL url) {
        super(url);
    }

    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File f = DataSetURL.getFile((URL)this.url, (ProgressMonitor)new NullProgressMonitor());
        ReadableByteChannel c = Channels.newChannel(new FileInputStream(f));
        DasProgressMonitorReadableByteChannel cmon = new DasProgressMonitorReadableByteChannel(c, mon);
        cmon.setStreamLength(f.length());
        CefReaderHeader readerh = new CefReaderHeader();
        this.cef = readerh.read((ReadableByteChannel)cmon);
        String var = (String)this.getParams().get("arg_0");
        MutablePropertyDataSet ds = null;
        MutablePropertyDataSet dsvar = this.createDataSet(var, ds, cmon);
        cmon.close();
        return dsvar;
    }

    public synchronized Map<String, Object> getMetaData(ProgressMonitor mon) throws Exception {
        String var = (String)this.getParams().get("arg_0");
        CefReaderHeader.ParamStruct param = this.cef.parameters.get(var);
        HashMap<String, Object> entries = new HashMap<String, Object>(param.entries);
        HashMap<String, String> restEntries = new HashMap<String, String>();
        for (String key : this.cef.parameters.keySet()) {
            CefReaderHeader.ParamStruct parm = this.cef.parameters.get(key);
            if (parm.sizes.length == 1 && parm.sizes[0] == 1) {
                restEntries.put(key, "[*] " + parm.entries.get("CATDESC"));
                continue;
            }
            String s = Arrays.toString(parm.sizes);
            s = s.substring(1, s.length() - 1);
            restEntries.put(key, "[*," + s + "] " + parm.entries.get("CATDESC"));
        }
        entries.put("CEF", restEntries);
        return entries;
    }

    private MutablePropertyDataSet createDataSet(String var, MutablePropertyDataSet tds, DasProgressMonitorReadableByteChannel cmon) throws IOException, NumberFormatException, ParseException {
        int i;
        int rank0;
        Object ds;
        CefReaderHeader.ParamStruct param = this.cef.parameters.get(var);
        int collapseDim = 999;
        Units u = Units.dimensionless;
        double fill = u.getFillDouble();
        String sceffill = (String)param.entries.get("FILLVAL");
        double ceffill = !param.entries.get("VALUE_TYPE").equals("ISO_TIME") ? (sceffill != null ? Double.parseDouble(sceffill) : fill) : fill;
        if (param.cefFieldPos[0] == -1) {
            String[] data = (String[])param.entries.get("DATA");
            double[] ddata = new double[data.length];
            for (int i2 = 0; i2 < data.length; ++i2) {
                try {
                    ddata[i2] = Double.parseDouble(data[i2]);
                    if (ddata[i2] != ceffill) continue;
                    ddata[i2] = fill;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("format error in data of param.name=" + param.name + ": " + data[i2]);
                }
            }
            ds = DDataSet.wrap((double[])ddata);
            ds.putProperty("NAME", (Object)var);
            rank0 = ds.rank();
        } else {
            int j;
            DDataSet dds;
            int i3;
            if (tds == null) {
                CefReaderData readerd = new CefReaderData();
                for (i3 = 0; i3 < 40000; ++i3) {
                    readerd.skipParse(i3);
                }
                this.setParseFlags(this.cef, var, readerd);
                tds = readerd.cefReadData((ReadableByteChannel)cmon, this.cef);
            }
            if (param.sizes.length > 1 || param.sizes[0] > 1) {
                if (tds == null) {
                    DataSetBuilder result = new DataSetBuilder(2, 0, param.cefFieldPos[1] - param.cefFieldPos[0] + 1, 1);
                    ds = result.getDataSet();
                } else {
                    ds = org.virbo.dataset.DataSetOps.leafTrim((QDataSet)tds, (int)param.cefFieldPos[0], (int)(param.cefFieldPos[1] + 1));
                }
                dds = DDataSet.copy((QDataSet)ds);
                dds.putProperty("UNITS", (Object)u);
                for (i3 = 0; i3 < dds.length(); ++i3) {
                    for (j = 0; j < dds.length(i3); ++j) {
                        if (dds.value(i3, j) != ceffill) continue;
                        dds.putValue(i3, j, fill);
                    }
                }
                ds = dds;
                ds.putProperty("NAME", (Object)var);
                if (param.sizes.length > 2) {
                    int[] sizes = new int[param.sizes.length + 1];
                    sizes[0] = ds.length();
                    int ndim = sizes.length;
                    for (i = 1; i < sizes.length; ++i) {
                        sizes[i] = param.sizes[ndim - i - 1];
                    }
                    ds = new ReformDataSet((QDataSet)ds, sizes);
                    rank0 = ds.rank();
                    if (ds.rank() == 4) {
                        collapseDim = 2;
                        ds = DataSetOps.collapse2((QDataSet)ds);
                    }
                } else {
                    rank0 = ds.rank();
                }
            } else {
                ds = tds == null ? DDataSet.createRank1((int)0) : org.virbo.dataset.DataSetOps.slice1((QDataSet)tds, (int)param.cefFieldPos[0]);
                rank0 = ds.rank();
                dds = DDataSet.copy((QDataSet)ds);
                dds.putProperty("UNITS", (Object)u);
                for (i3 = 0; i3 < dds.length(); ++i3) {
                    for (j = 0; j < dds.length(i3); ++j) {
                        if (dds.value(i3, j) != ceffill) continue;
                        dds.putValue(i3, j, fill);
                    }
                }
                ds = dds;
                ds.putProperty("NAME", (Object)var);
            }
        }
        if (param.entries.get("VALUE_TYPE").equals("ISO_TIME")) {
            ds.putProperty("UNITS", (Object)Units.us2000);
            if (DataSetUtil.isMonotonic((QDataSet)ds)) {
                ds.putProperty("MONOTONIC", (Object)Boolean.TRUE);
            }
        }
        int[] qube = DataSetUtil.qubeDims((QDataSet)ds);
        boolean doDeps = true;
        if (doDeps) {
            for (i = 0; i < rank0; ++i) {
                String s = (String)param.entries.get("DEPEND_" + i);
                if (s == null) continue;
                int newDim = i;
                if (i > collapseDim) {
                    newDim = i - 1;
                } else {
                    if (i >= collapseDim) continue;
                    newDim = i;
                }
                MutablePropertyDataSet dep0ds = this.createDataSet(s, tds, cmon);
                if (dep0ds.rank() > 1) {
                    QDataSet dp01 = (QDataSet)dep0ds.property("DEPEND_0");
                    QDataSet dp02 = (QDataSet)ds.property("DEPEND_0");
                    if (dp01 != null && dp02 != null && dp01.length() == dp02.length()) {
                        if ((dep0ds = org.virbo.dataset.DataSetOps.slice0((QDataSet)dep0ds, (int)0)).length() > qube[newDim]) {
                            dep0ds = org.virbo.dataset.DataSetOps.trim((QDataSet)dep0ds, (int)0, (int)qube[newDim]);
                        }
                        if (!DataSetUtil.isMonotonic((QDataSet)dep0ds)) {
                            QDataSet sort = org.virbo.dataset.DataSetOps.sort((QDataSet)dep0ds);
                            dep0ds = new SortDataSet((QDataSet)dep0ds, sort);
                            ds = this.makeMonotonic((MutablePropertyDataSet)ds, newDim, sort);
                            System.err.println(DataSetUtil.statsString((QDataSet)ds));
                        }
                    }
                }
                ds.putProperty("DEPEND_" + newDim, (Object)dep0ds);
            }
        }
        try {
            Map<String, Object> m = this.getMetaData((ProgressMonitor)new NullProgressMonitor());
            Map<String, Object> props = new CefMetadataModel().properties(m);
            DataSetUtil.putProperties(props, (MutablePropertyDataSet)ds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ds;
    }

    private MutablePropertyDataSet makeMonotonic(MutablePropertyDataSet ds, int idim, QDataSet sort) {
        DDataSet cds;
        block15: {
            int[] qube;
            block16: {
                block14: {
                    if (idim > 2) {
                        throw new IllegalArgumentException("idim must be <=2 ");
                    }
                    if (ds.rank() > 3) {
                        throw new IllegalArgumentException("rank limit");
                    }
                    qube = DataSetUtil.qubeDims((QDataSet)ds);
                    qube[idim] = sort.length();
                    cds = DDataSet.create((int[])qube);
                    DataSetUtil.putProperties((Map)DataSetUtil.getProperties((QDataSet)ds), (MutablePropertyDataSet)cds);
                    if (idim != 0) break block14;
                    for (int i = 0; i < qube[0]; ++i) {
                        if (ds.rank() > 1) {
                            for (int j = 0; j < qube[1]; ++j) {
                                if (ds.rank() > 2) {
                                    for (int k = 0; k < qube[2]; ++k) {
                                        double d = ds.value((int)sort.value(i), j, k);
                                        cds.putValue(i, j, k, d);
                                    }
                                    continue;
                                }
                                double d = ds.value((int)sort.value(i), j);
                                cds.putValue(i, j, d);
                            }
                            continue;
                        }
                        double d = ds.value((int)sort.value(i));
                        cds.putValue(i, d);
                    }
                    break block15;
                }
                if (idim != 1) break block16;
                for (int i = 0; i < qube[0]; ++i) {
                    for (int j = 0; j < qube[1]; ++j) {
                        if (ds.rank() > 2) {
                            for (int k = 0; k < qube[2]; ++k) {
                                double d = ds.value(i, (int)sort.value(j), k);
                                cds.putValue(i, j, k, d);
                            }
                            continue;
                        }
                        double d = ds.value(i, (int)sort.value(j));
                        cds.putValue(i, j, d);
                    }
                }
                break block15;
            }
            if (idim != 2) break block15;
            for (int i = 0; i < qube[0]; ++i) {
                for (int j = 0; j < qube[1]; ++j) {
                    for (int k = 0; k < qube[2]; ++k) {
                        double d = ds.value(i, j, (int)sort.value(k));
                        cds.putValue(i, j, k, d);
                    }
                }
            }
        }
        return cds;
    }

    private void setParseFlags(Cef cef, String var, CefReaderData readerd) {
        CefReaderHeader.ParamStruct param = cef.parameters.get(var);
        if (param.cefFieldPos[0] != -1) {
            for (int i = param.cefFieldPos[0]; i < param.cefFieldPos[1] + 1; ++i) {
                readerd.doParse(i);
            }
        }
        for (int i = 0; i < 4; ++i) {
            String s = (String)param.entries.get("DEPEND_" + i);
            if (s == null) continue;
            this.setParseFlags(cef, s, readerd);
        }
    }

    public MetadataModel getMetadataModel() {
        return new CefMetadataModel();
    }
}

