/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.NameAndTypeUsageMarker;

public class NameAndTypeShrinker
implements ClassVisitor {
    private int[] constantIndexMap;
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2constantPoolCount = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        int n2;
        if (this.constantIndexMap == null || this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n3 = 1;
        boolean bl = false;
        for (n2 = 1; n2 < n; ++n2) {
            this.constantIndexMap[n2] = n3;
            Constant constant = constantArray[n2];
            if (constant != null) {
                boolean bl2 = bl = constant.getTag() != 12 || NameAndTypeUsageMarker.isUsed(constant);
            }
            if (!bl) continue;
            constantArray[n3++] = constant;
        }
        for (n2 = n3; n2 < n; ++n2) {
            constantArray[n2] = null;
        }
        return n3;
    }
}

