/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintStream;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class MappingPrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final PrintStream ps;

    public MappingPrinter() {
        this(System.out);
    }

    public MappingPrinter(PrintStream printStream) {
        this.ps = printStream;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        String string = programClass.getName();
        String string2 = ClassObfuscator.newClassName(programClass);
        this.ps.println(ClassUtil.externalClassName(string) + " -> " + ClassUtil.externalClassName(string2) + ":");
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string = MemberObfuscator.newMemberName(programField);
        if (string != null) {
            this.ps.println("    " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + " -> " + string);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        String string2 = MemberObfuscator.newMemberName(programMethod);
        if (string2 != null) {
            this.ps.println("    " + MappingPrinter.lineNumberRange(programClass, programMethod) + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + " -> " + string2);
        }
    }

    private static String lineNumberRange(ProgramClass programClass, ProgramMember programMember) {
        String string = programMember.getLineNumberRange(programClass);
        return string != null ? string + ":" : "";
    }
}

