/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class DataEntryRenamer
implements DataEntryReader {
    private final ClassPool classPool;
    private final DataEntryReader dataEntryReader;

    public DataEntryRenamer(ClassPool classPool, DataEntryReader dataEntryReader) {
        this.classPool = classPool;
        this.dataEntryReader = dataEntryReader;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        this.dataEntryReader.read(this.renamedDataEntry(dataEntry));
    }

    private DataEntry renamedDataEntry(DataEntry dataEntry) {
        String string = dataEntry.getName();
        for (int i = string.length() - 1; i > 0; --i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            if (c == '/') break;
            String string2 = string.substring(0, i);
            Clazz clazz = this.classPool.getClass(string2);
            if (clazz == null) continue;
            String string3 = clazz.getName();
            if (string2.equals(string3)) break;
            String string4 = i > 0 ? string3 + string.substring(i) : string3;
            return new RenamedDataEntry(dataEntry, string4);
        }
        return dataEntry;
    }
}

