/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;
import proguard.gui.MemberSpecificationDialog;

final class MemberSpecificationsPanel
extends ListPanel {
    private final MemberSpecificationDialog fieldSpecificationDialog;
    private final MemberSpecificationDialog methodSpecificationDialog;

    public MemberSpecificationsPanel(JDialog jDialog, boolean bl) {
        this.firstSelectionButton = bl ? 3 : 2;
        this.list.setCellRenderer(new MyListCellRenderer());
        this.fieldSpecificationDialog = new MemberSpecificationDialog(jDialog, true);
        this.methodSpecificationDialog = new MemberSpecificationDialog(jDialog, false);
        if (bl) {
            this.addAddFieldButton();
        }
        this.addAddMethodButton();
        this.addEditButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddFieldButton() {
        JButton jButton = new JButton(MemberSpecificationsPanel.msg("addField"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemberSpecificationsPanel.this.fieldSpecificationDialog.setMemberSpecification(new MemberSpecification());
                int n = MemberSpecificationsPanel.this.fieldSpecificationDialog.showDialog();
                if (n == 0) {
                    MemberSpecificationsPanel.this.addElement(new MyMemberSpecificationWrapper(MemberSpecificationsPanel.this.fieldSpecificationDialog.getMemberSpecification(), true));
                }
            }
        });
        this.addButton(MemberSpecificationsPanel.tip(jButton, "addFieldTip"));
    }

    protected void addAddMethodButton() {
        JButton jButton = new JButton(MemberSpecificationsPanel.msg("addMethod"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemberSpecificationsPanel.this.methodSpecificationDialog.setMemberSpecification(new MemberSpecification());
                int n = MemberSpecificationsPanel.this.methodSpecificationDialog.showDialog();
                if (n == 0) {
                    MemberSpecificationsPanel.this.addElement(new MyMemberSpecificationWrapper(MemberSpecificationsPanel.this.methodSpecificationDialog.getMemberSpecification(), false));
                }
            }
        });
        this.addButton(MemberSpecificationsPanel.tip(jButton, "addMethodTip"));
    }

    protected void addEditButton() {
        JButton jButton = new JButton(MemberSpecificationsPanel.msg("edit"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MyMemberSpecificationWrapper myMemberSpecificationWrapper = (MyMemberSpecificationWrapper)MemberSpecificationsPanel.this.list.getSelectedValue();
                MemberSpecificationDialog memberSpecificationDialog = myMemberSpecificationWrapper.isField ? MemberSpecificationsPanel.this.fieldSpecificationDialog : MemberSpecificationsPanel.this.methodSpecificationDialog;
                memberSpecificationDialog.setMemberSpecification(myMemberSpecificationWrapper.memberSpecification);
                int n = memberSpecificationDialog.showDialog();
                if (n == 0) {
                    myMemberSpecificationWrapper.memberSpecification = memberSpecificationDialog.getMemberSpecification();
                    MemberSpecificationsPanel.this.setElementAt(myMemberSpecificationWrapper, MemberSpecificationsPanel.this.list.getSelectedIndex());
                }
            }
        });
        this.addButton(MemberSpecificationsPanel.tip(jButton, "editTip"));
    }

    public void setMemberSpecifications(List list, List list2) {
        int n;
        this.listModel.clear();
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                this.listModel.addElement(new MyMemberSpecificationWrapper((MemberSpecification)list.get(n), true));
            }
        }
        if (list2 != null) {
            for (n = 0; n < list2.size(); ++n) {
                this.listModel.addElement(new MyMemberSpecificationWrapper((MemberSpecification)list2.get(n), false));
            }
        }
        this.enableSelectionButtons();
    }

    public List getMemberSpecifications(boolean bl) {
        int n = this.listModel.size();
        if (n == 0) {
            return null;
        }
        ArrayList<MemberSpecification> arrayList = new ArrayList<MemberSpecification>(n);
        for (int i = 0; i < n; ++i) {
            MyMemberSpecificationWrapper myMemberSpecificationWrapper = (MyMemberSpecificationWrapper)this.listModel.get(i);
            if (myMemberSpecificationWrapper.isField != bl) continue;
            arrayList.add(myMemberSpecificationWrapper.memberSpecification);
        }
        return arrayList;
    }

    private static JComponent tip(JComponent jComponent, String string) {
        jComponent.setToolTipText(MemberSpecificationsPanel.msg(string));
        return jComponent;
    }

    private static String msg(String string) {
        return GUIResources.getMessage(string);
    }

    private static class MyMemberSpecificationWrapper {
        public MemberSpecification memberSpecification;
        public final boolean isField;

        public MyMemberSpecificationWrapper(MemberSpecification memberSpecification, boolean bl) {
            this.memberSpecification = memberSpecification;
            this.isField = bl;
        }
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JLabel label = new JLabel();

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            MyMemberSpecificationWrapper myMemberSpecificationWrapper = (MyMemberSpecificationWrapper)object;
            MemberSpecification memberSpecification = myMemberSpecificationWrapper.memberSpecification;
            String string = memberSpecification.name;
            String string2 = memberSpecification.descriptor;
            this.label.setText(myMemberSpecificationWrapper.isField ? (string2 == null ? (string == null ? "<fields>" : "*** " + string) : ClassUtil.externalFullFieldDescription(0, string == null ? "*" : string, string2)) : (string2 == null ? (string == null ? "<methods>" : "*** " + string + "(...)") : ClassUtil.externalFullMethodDescription("<init>", 0, string == null ? "*" : string, string2)));
            if (bl) {
                this.label.setBackground(jList.getSelectionBackground());
                this.label.setForeground(jList.getSelectionForeground());
            } else {
                this.label.setBackground(jList.getBackground());
                this.label.setForeground(jList.getForeground());
            }
            this.label.setOpaque(true);
            return this.label;
        }
    }
}

