/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableRemapper
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private int[] variableMap;

    public void setVariableMap(int[] nArray) {
        this.variableMap = nArray;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2index = this.remapVariable(localVariableInfo.u2index);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2index = this.remapVariable(localVariableTypeInfo.u2index);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        int n3 = this.remapVariable(n2);
        if (n3 != n2) {
            Instruction instruction = new VariableInstruction(variableInstruction.opcode, n3, variableInstruction.constant).shrink();
            this.codeAttributeEditor.replaceInstruction(n, instruction);
        }
    }

    private int remapVariable(int n) {
        return this.variableMap[n];
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableInfo localVariableInfo = localVariableInfoArray[i];
            if (localVariableInfo.u2index < 0) continue;
            localVariableInfoArray[n2++] = localVariableInfo;
        }
        return n2;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfoArray[i];
            if (localVariableTypeInfo.u2index < 0) continue;
            localVariableTypeInfoArray[n2++] = localVariableTypeInfo;
        }
        return n2;
    }
}

