/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AreaI;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.AreaReference;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public abstract class AreaPtgBase
extends OperandPtg
implements AreaI {
    public static final short sid = 37;
    private static final int SIZE = 9;
    private int field_1_first_row;
    private int field_2_last_row;
    private int field_3_first_column;
    private int field_4_last_column;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField columnMask = BitFieldFactory.getInstance(16383);

    protected final RuntimeException notImplemented() {
        return new RuntimeException("Coding Error: This method should never be called. This ptg should be converted");
    }

    protected AreaPtgBase(String arearef) {
        AreaReference ar = new AreaReference(arearef);
        CellReference firstCell = ar.getFirstCell();
        CellReference lastCell = ar.getLastCell();
        this.setFirstRow(firstCell.getRow());
        this.setFirstColumn(firstCell.getCol());
        this.setLastRow(lastCell.getRow());
        this.setLastColumn(lastCell.getCol());
        this.setFirstColRelative(!firstCell.isColAbsolute());
        this.setLastColRelative(!lastCell.isColAbsolute());
        this.setFirstRowRelative(!firstCell.isRowAbsolute());
        this.setLastRowRelative(!lastCell.isRowAbsolute());
    }

    protected AreaPtgBase(int firstRow, int lastRow, int firstColumn, int lastColumn, boolean firstRowRelative, boolean lastRowRelative, boolean firstColRelative, boolean lastColRelative) {
        AreaPtgBase.checkColumnBounds(firstColumn);
        AreaPtgBase.checkColumnBounds(lastColumn);
        AreaPtgBase.checkRowBounds(firstRow);
        AreaPtgBase.checkRowBounds(lastRow);
        this.setFirstRow(firstRow);
        this.setLastRow(lastRow);
        this.setFirstColumn(firstColumn);
        this.setLastColumn(lastColumn);
        this.setFirstRowRelative(firstRowRelative);
        this.setLastRowRelative(lastRowRelative);
        this.setFirstColRelative(firstColRelative);
        this.setLastColRelative(lastColRelative);
    }

    private static void checkColumnBounds(int colIx) {
        if ((colIx & 0xFF) != colIx) {
            throw new IllegalArgumentException("colIx (" + colIx + ") is out of range");
        }
    }

    private static void checkRowBounds(int rowIx) {
        if ((rowIx & 0xFFFF) != rowIx) {
            throw new IllegalArgumentException("rowIx (" + rowIx + ") is out of range");
        }
    }

    protected AreaPtgBase(RecordInputStream in) {
        this.field_1_first_row = in.readUShort();
        this.field_2_last_row = in.readUShort();
        this.field_3_first_column = in.readUShort();
        this.field_4_last_column = in.readUShort();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(AreaReference.formatAsString(this));
        sb.append("]");
        return sb.toString();
    }

    protected abstract byte getSid();

    public final void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(this.getSid() + this.getPtgClass());
        LittleEndian.putShort(array, offset + 1, (short)this.field_1_first_row);
        LittleEndian.putShort(array, offset + 3, (short)this.field_2_last_row);
        LittleEndian.putShort(array, offset + 5, (short)this.field_3_first_column);
        LittleEndian.putShort(array, offset + 7, (short)this.field_4_last_column);
    }

    public final int getSize() {
        return 9;
    }

    public final int getFirstRow() {
        return this.field_1_first_row;
    }

    public final void setFirstRow(int rowIx) {
        AreaPtgBase.checkRowBounds(rowIx);
        this.field_1_first_row = rowIx;
    }

    public final int getLastRow() {
        return this.field_2_last_row;
    }

    public final void setLastRow(int rowIx) {
        AreaPtgBase.checkRowBounds(rowIx);
        this.field_2_last_row = rowIx;
    }

    public final int getFirstColumn() {
        return columnMask.getValue(this.field_3_first_column);
    }

    public final short getFirstColumnRaw() {
        return (short)this.field_3_first_column;
    }

    public final boolean isFirstRowRelative() {
        return rowRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstRowRelative(boolean rel) {
        this.field_3_first_column = rowRelative.setBoolean(this.field_3_first_column, rel);
    }

    public final boolean isFirstColRelative() {
        return colRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstColRelative(boolean rel) {
        this.field_3_first_column = colRelative.setBoolean(this.field_3_first_column, rel);
    }

    public final void setFirstColumn(int colIx) {
        AreaPtgBase.checkColumnBounds(colIx);
        this.field_3_first_column = columnMask.setValue(this.field_3_first_column, colIx);
    }

    public final void setFirstColumnRaw(int column) {
        this.field_3_first_column = column;
    }

    public final int getLastColumn() {
        return columnMask.getValue(this.field_4_last_column);
    }

    public final short getLastColumnRaw() {
        return (short)this.field_4_last_column;
    }

    public final boolean isLastRowRelative() {
        return rowRelative.isSet(this.field_4_last_column);
    }

    public final void setLastRowRelative(boolean rel) {
        this.field_4_last_column = rowRelative.setBoolean(this.field_4_last_column, rel);
    }

    public final boolean isLastColRelative() {
        return colRelative.isSet(this.field_4_last_column);
    }

    public final void setLastColRelative(boolean rel) {
        this.field_4_last_column = colRelative.setBoolean(this.field_4_last_column, rel);
    }

    public final void setLastColumn(int colIx) {
        AreaPtgBase.checkColumnBounds(colIx);
        this.field_4_last_column = columnMask.setValue(this.field_4_last_column, colIx);
    }

    public final void setLastColumnRaw(short column) {
        this.field_4_last_column = column;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return AreaReference.formatAsString(this);
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

