/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;

public class FormatTrackingHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private Map customFormatRecords = new Hashtable();
    private List xfRecords = new ArrayList();

    public FormatTrackingHSSFListener(HSSFListener childListener) {
        this.childListener = childListener;
    }

    public void processRecord(Record record) {
        this.processRecordInternally(record);
        this.childListener.processRecord(record);
    }

    public void processRecordInternally(Record record) {
        if (record instanceof FormatRecord) {
            FormatRecord fr = (FormatRecord)record;
            this.customFormatRecords.put(new Integer(fr.getIndexCode()), fr);
        }
        if (record instanceof ExtendedFormatRecord) {
            ExtendedFormatRecord xr = (ExtendedFormatRecord)record;
            this.xfRecords.add(xr);
        }
    }

    public String getFormatString(int formatIndex) {
        String format = null;
        if (formatIndex >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord tfr = (FormatRecord)this.customFormatRecords.get(new Integer(formatIndex));
            if (tfr == null) {
                System.err.println("Requested format at index " + formatIndex + ", but it wasn't found");
            } else {
                format = tfr.getFormatString();
            }
        } else {
            format = HSSFDataFormat.getBuiltinFormat((short)formatIndex);
        }
        return format;
    }

    public String getFormatString(CellValueRecordInterface cell) {
        int formatIndex = this.getFormatIndex(cell);
        if (formatIndex == -1) {
            return null;
        }
        return this.getFormatString(formatIndex);
    }

    public int getFormatIndex(CellValueRecordInterface cell) {
        ExtendedFormatRecord xfr = (ExtendedFormatRecord)this.xfRecords.get(cell.getXFIndex());
        if (xfr == null) {
            System.err.println("Cell " + cell.getRow() + "," + cell.getColumn() + " uses XF with index " + cell.getXFIndex() + ", but we don't have that");
            return -1;
        }
        return xfr.getFormatIndex();
    }
}

