/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.pds.label.object.RecordLocation;
import gov.nasa.pds.label.object.TableRecord;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedTableRecord
implements TableRecord {
    private int fieldCount;
    private List<String> items;
    private String[] recordValue = null;
    private Map<String, Integer> fieldMap = new HashMap<String, Integer>();
    private RecordLocation location;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelimitedTableRecord.class);

    DelimitedTableRecord(Map<String, Integer> map, int fieldCount) {
        this.fieldMap = map;
        this.fieldCount = fieldCount;
        this.items = new ArrayList<String>(fieldCount);
        this.location = null;
        this.initializeItems();
    }

    DelimitedTableRecord(Map<String, Integer> map, int fieldCount, String[] value) {
        this.fieldMap = map;
        this.fieldCount = fieldCount;
        this.location = null;
        this.setRecordValue(value);
    }

    @Override
    public int findColumn(String name) {
        this.checkFieldName(name);
        return this.fieldMap.get(name);
    }

    @Override
    public boolean getBoolean(String name) {
        this.checkFieldName(name);
        return this.getBoolean(this.fieldMap.get(name));
    }

    @Override
    public boolean getBoolean(int index) {
        this.checkIndexRange(index);
        String value = this.recordValue[index - 1].trim();
        if (value.equals("true") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Field value is not a valid boolean (" + value + ")");
    }

    @Override
    public short getShort(int index) {
        this.checkIndexRange(index);
        int value = Integer.parseInt(this.recordValue[index - 1].trim());
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new NumberFormatException("Value is out of range of a short (" + value + ")");
        }
        return (short)value;
    }

    @Override
    public short getShort(String name) {
        this.checkFieldName(name);
        return this.getShort(this.fieldMap.get(name));
    }

    @Override
    public byte getByte(int index) {
        this.checkIndexRange(index);
        int value = Integer.parseInt(this.recordValue[index - 1].trim());
        if (value < -128 || value > 127) {
            throw new NumberFormatException("Value is out of range of a byte (" + value + ")");
        }
        return (byte)value;
    }

    @Override
    public byte getByte(String name) {
        this.checkFieldName(name);
        return this.getByte(this.fieldMap.get(name));
    }

    @Override
    public long getLong(int index) {
        this.checkIndexRange(index);
        return Long.parseLong(this.recordValue[index - 1].trim());
    }

    @Override
    public long getLong(String name) {
        this.checkFieldName(name);
        return this.getLong(this.fieldMap.get(name));
    }

    @Override
    public int getInt(int index) {
        this.checkIndexRange(index);
        return Integer.parseInt(this.recordValue[index - 1].trim());
    }

    @Override
    public int getInt(String name) {
        this.checkFieldName(name);
        return this.getInt(this.fieldMap.get(name));
    }

    @Override
    public double getDouble(int index) {
        this.checkIndexRange(index);
        return Double.parseDouble(this.recordValue[index - 1].trim());
    }

    @Override
    public double getDouble(String name) {
        this.checkFieldName(name);
        return this.getDouble(this.fieldMap.get(name));
    }

    @Override
    public float getFloat(int index) {
        this.checkIndexRange(index);
        return Float.parseFloat(this.recordValue[index - 1].trim());
    }

    @Override
    public float getFloat(String name) {
        this.checkFieldName(name);
        return this.getFloat(this.fieldMap.get(name));
    }

    @Override
    public BigInteger getBigInteger(String name) {
        this.checkFieldName(name);
        return this.getBigInteger(this.fieldMap.get(name));
    }

    @Override
    public BigInteger getBigInteger(int index) {
        this.checkIndexRange(index);
        return new BigInteger(this.recordValue[index - 1]);
    }

    @Override
    public String getString(int index) {
        this.checkIndexRange(index);
        return this.recordValue[index - 1];
    }

    @Override
    public String getString(int index, Charset charset) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public String getString(String name) {
        this.checkFieldName(name);
        return this.getString(this.fieldMap.get(name));
    }

    @Override
    public String getString(String name, Charset charset) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void setString(int index, String value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, value);
    }

    @Override
    public void setString(String name, String value) {
        this.checkFieldName(name);
        this.setString(this.fieldMap.get(name), value);
    }

    @Override
    public void setString(String value) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void setInt(int index, int value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, Integer.toString(value));
    }

    @Override
    public void setInt(String name, int value) {
        this.checkFieldName(name);
        this.setInt(this.fieldMap.get(name), value);
    }

    @Override
    public void setDouble(int index, double value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, Double.toString(value));
    }

    @Override
    public void setDouble(String name, double value) {
        this.checkFieldName(name);
        this.setDouble(this.fieldMap.get(name), value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, Float.toString(value));
    }

    @Override
    public void setFloat(String name, float value) {
        this.checkFieldName(name);
        this.setFloat(this.fieldMap.get(name), value);
    }

    @Override
    public void setLong(int index, long value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, Long.toString(value));
    }

    @Override
    public void setLong(String name, long value) {
        this.checkFieldName(name);
        this.setLong(this.fieldMap.get(name), value);
    }

    @Override
    public void setShort(int index, short value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, Short.toString(value));
    }

    @Override
    public void setShort(String name, short value) {
        this.checkFieldName(name);
        this.setShort(this.fieldMap.get(name), value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.checkIndexRange(index);
        this.items.remove(index - 1);
        this.items.add(index - 1, Byte.toString(value));
    }

    @Override
    public void setByte(String name, byte value) {
        this.checkFieldName(name);
        this.setByte(this.fieldMap.get(name), value);
    }

    @Override
    public void clear() {
        this.items.clear();
        this.initializeItems();
    }

    public void setRecordValue(String[] value) {
        this.recordValue = value;
    }

    public String[] getRecordValue() {
        return this.items.toArray(new String[this.items.size()]);
    }

    private void checkIndexRange(int index) {
        if (index <= 0 || index > this.fieldCount) {
            String msg = "The index is out of range (1 to " + this.fieldCount + ").";
            LOGGER.error(msg);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    private void initializeItems() {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.items.add("");
        }
    }

    private void checkFieldName(String name) {
        if (!this.fieldMap.containsKey(name)) {
            String msg = "'" + name + "' is not a valid field name.";
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public RecordLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(RecordLocation location) {
        this.location = location;
    }
}

